/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppUtils;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class PrivateRegistryRuntimeHandlerImpl
implements RuntimeHandler {
    public static final String SERVER_ID_NOT_FOUND = "Server Id not found in settings.xml. ServerId=";
    private AbstractWebAppMojo mojo;

    public PrivateRegistryRuntimeHandlerImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRunTime() throws MojoExecutionException {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        Server server = Utils.getServer((Settings)this.mojo.getSettings(), (String)containerSetting.getServerId());
        if (server == null) {
            throw new MojoExecutionException(SERVER_ID_NOT_FOUND + containerSetting.getServerId());
        }
        return WebAppUtils.defineApp(this.mojo).withNewLinuxPlan(this.mojo.getPricingTier()).withPrivateRegistryImage(containerSetting.getImageName(), containerSetting.getRegistryUrl()).withCredentials(server.getUsername(), server.getPassword());
    }

    @Override
    public WebApp.Update updateAppRuntime() throws MojoExecutionException {
        WebApp app = this.mojo.getWebApp();
        WebAppUtils.assureLinuxWebApp(app);
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        Server server = Utils.getServer((Settings)this.mojo.getSettings(), (String)containerSetting.getServerId());
        if (server == null) {
            throw new MojoExecutionException(SERVER_ID_NOT_FOUND + containerSetting.getServerId());
        }
        return ((WebApp.Update)app.update()).withPrivateRegistryImage(containerSetting.getImageName(), containerSetting.getRegistryUrl()).withCredentials(server.getUsername(), server.getPassword());
    }
}

