/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class WebAppUtils {
    public static final String CONTAINER_SETTING_NOT_APPLICABLE = "<containerSettings> is not applicable to Web App on Windows; please use <javaVersion> and <javaWebContainer> to configure your runtime.";
    public static final String JAVA_VERSION_NOT_APPLICABLE = "<javaVersion> is not applicable to Web App on Linux; please use <containerSettings> to specify your runtime.";

    private static boolean isLinuxWebApp(WebApp app) {
        return ((SiteInner)app.inner()).kind().contains("linux");
    }

    public static void assureLinuxWebApp(WebApp app) throws MojoExecutionException {
        if (!WebAppUtils.isLinuxWebApp(app)) {
            throw new MojoExecutionException(CONTAINER_SETTING_NOT_APPLICABLE);
        }
    }

    public static void assureWindowsWebApp(WebApp app) throws MojoExecutionException {
        if (WebAppUtils.isLinuxWebApp(app)) {
            throw new MojoExecutionException(JAVA_VERSION_NOT_APPLICABLE);
        }
    }

    public static WebApp.DefinitionStages.WithNewAppServicePlan defineApp(AbstractWebAppMojo mojo) {
        if (mojo.getAzureClient().resourceGroups().checkExistence(mojo.getResourceGroup())) {
            return (WebApp.DefinitionStages.WithNewAppServicePlan)((WebApp.DefinitionStages.NewAppServicePlanWithGroup)((WebApp.DefinitionStages.Blank)mojo.getAzureClient().webApps().define(mojo.getAppName())).withRegion(mojo.getRegion())).withExistingResourceGroup(mojo.getResourceGroup());
        }
        return (WebApp.DefinitionStages.WithNewAppServicePlan)((WebApp.DefinitionStages.NewAppServicePlanWithGroup)((WebApp.DefinitionStages.Blank)mojo.getAzureClient().webApps().define(mojo.getAppName())).withRegion(mojo.getRegion())).withNewResourceGroup(mojo.getResourceGroup());
    }

    public static boolean isPublicDockerHubImage(ContainerSetting containerSetting) {
        return StringUtils.isEmpty((String)containerSetting.getServerId()) && StringUtils.isEmpty((String)containerSetting.getRegistryUrl());
    }

    public static boolean isPrivateDockerHubImage(ContainerSetting containerSetting) {
        return StringUtils.isNotEmpty((String)containerSetting.getServerId()) && StringUtils.isEmpty((String)containerSetting.getRegistryUrl());
    }

    public static boolean isPrivateRegistryImage(ContainerSetting containerSetting) {
        return StringUtils.isNotEmpty((String)containerSetting.getServerId()) && StringUtils.isNotEmpty((String)containerSetting.getRegistryUrl());
    }

    public static void clearTags(WebApp app) {
        ((SiteInner)app.inner()).withTags(null);
    }
}

