/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.DeploymentType;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandler;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class SettingsHandlerImpl
implements SettingsHandler {
    private AbstractWebAppMojo mojo;

    public SettingsHandlerImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void processSettings(WebApp.DefinitionStages.WithCreate withCreate) throws MojoExecutionException {
        DeploymentType deploymentType;
        Map appSettings = this.mojo.getAppSettings();
        if (appSettings != null && !appSettings.isEmpty()) {
            withCreate.withAppSettings(appSettings);
        }
        if ((deploymentType = this.mojo.getDeploymentType()) == DeploymentType.LOCAL_GIT) {
            withCreate.withLocalGitSourceControl();
        }
    }

    @Override
    public void processSettings(WebApp.Update update) throws MojoExecutionException {
        DeploymentType deploymentType;
        Map appSettings = this.mojo.getAppSettings();
        if (appSettings != null && !appSettings.isEmpty()) {
            update.withAppSettings(appSettings);
        }
        if ((deploymentType = this.mojo.getDeploymentType()) == DeploymentType.LOCAL_GIT) {
            update.withLocalGitSourceControl();
        }
    }
}

