/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.common.appservice.DockerImageType;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.utils.SystemPropertyUtils;
import com.microsoft.azure.maven.webapp.WebAppConfig;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.MavenRuntimeConfig;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.parser.AbstractConfigParser;
import com.microsoft.azure.maven.webapp.parser.V1ConfigParser;
import com.microsoft.azure.maven.webapp.parser.V2ConfigParser;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import com.microsoft.azure.maven.webapp.validator.V1ConfigurationValidator;
import com.microsoft.azure.maven.webapp.validator.V2ConfigurationValidator;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureLoginException;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractWebAppMojo
extends AbstractAppServiceMojo {
    public static final String JAVA_VERSION_KEY = "javaVersion";
    public static final String JAVA_WEB_CONTAINER_KEY = "javaWebContainer";
    public static final String DOCKER_IMAGE_TYPE_KEY = "dockerImageType";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    public static final String OS_KEY = "os";
    public static final String INVALID_CONFIG_KEY = "invalidConfiguration";
    public static final String SCHEMA_VERSION_KEY = "schemaVersion";
    public static final String DEPLOY_TO_SLOT_KEY = "isDeployToSlot";
    @Parameter(property="webapp.pricingTier")
    protected String pricingTier;
    @Deprecated
    @Parameter(property="webapp.javaVersion")
    protected String javaVersion;
    @Deprecated
    @Parameter(property="webapp.javaWebContainer", defaultValue="tomcat 8.5")
    protected String javaWebContainer;
    @Deprecated
    @Parameter(property="webapp.linuxRuntime")
    protected String linuxRuntime;
    @Deprecated
    @Parameter
    protected ContainerSetting containerSettings;
    @Deprecated
    @Parameter(property="webapp.stopAppDuringDeployment", defaultValue="false")
    protected boolean stopAppDuringDeployment;
    @Deprecated
    @Parameter(property="webapp.resources")
    protected List<Resource> resources;
    @Parameter(property="webapp.skip", defaultValue="false")
    protected boolean skip;
    @Deprecated
    @Parameter(property="webapp.warFile")
    protected String warFile;
    @Deprecated
    @Parameter(property="webapp.jarFile")
    protected String jarFile;
    @Deprecated
    @Parameter(property="webapp.path", defaultValue="/")
    protected String path;
    @Parameter(property="webapp.region")
    protected String region;
    @Parameter(property="schemaVersion", defaultValue="v2")
    protected String schemaVersion;
    @Parameter(property="runtime")
    protected MavenRuntimeConfig runtime;
    @Parameter(property="deployment")
    protected Deployment deployment;
    private WebAppConfiguration webAppConfiguration;
    protected File stagingDirectory;
    protected AzureAppService az;
    private boolean isRuntimeInjected = false;
    private AzureAppService appServiceClient;

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName == null ? "" : this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getLinuxRuntime() {
        return this.linuxRuntime;
    }

    public WebContainer getJavaWebContainer() {
        return StringUtils.isEmpty((CharSequence)this.javaWebContainer) ? WebContainer.TOMCAT_8_5_NEWEST : WebContainer.fromString((String)this.javaWebContainer);
    }

    public ContainerSetting getContainerSettings() {
        return this.containerSettings;
    }

    public boolean isStopAppDuringDeployment() {
        return this.stopAppDuringDeployment;
    }

    public List<Resource> getResources() {
        return this.resources == null ? Collections.emptyList() : this.resources;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public String getPath() {
        return this.path;
    }

    public WebApp getWebApp() throws AzureAuthFailureException, AzureExecutionException {
        return (WebApp)this.getAzureClient().webApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
    }

    public DeploymentSlot getDeploymentSlot(WebApp app, String slotName) {
        DeploymentSlot slot = null;
        if (StringUtils.isNotEmpty((CharSequence)slotName)) {
            try {
                slot = (DeploymentSlot)app.deploymentSlots().getByName(slotName);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return slot;
    }

    public boolean isDeployToDeploymentSlot() {
        return this.getDeploymentSlotSetting() != null;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public MavenRuntimeConfig getRuntime() {
        if (!this.isRuntimeInjected) {
            this.setRuntime((MavenRuntimeConfig)SystemPropertyUtils.injectCommandLineParameter((String)"runtime", (Object)this.runtime, MavenRuntimeConfig.class));
            this.isRuntimeInjected = true;
        }
        return this.runtime;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setRuntime(MavenRuntimeConfig runtime) {
        this.runtime = runtime;
    }

    public Map<String, String> getTelemetryProperties() {
        WebAppConfig webAppConfig;
        Map map = super.getTelemetryProperties();
        try {
            webAppConfig = this.getWebAppConfig();
        }
        catch (Exception e) {
            map.put(INVALID_CONFIG_KEY, e.getMessage());
            return map;
        }
        if (webAppConfig.getDockerConfiguration() != null) {
            DockerConfiguration dockerConfiguration = webAppConfig.getDockerConfiguration();
            String imageType = AppServiceUtils.getDockerImageType((String)dockerConfiguration.getImage(), (boolean)StringUtils.isEmpty((CharSequence)dockerConfiguration.getPassword()), (String)dockerConfiguration.getRegistryUrl()).name();
            map.put(DOCKER_IMAGE_TYPE_KEY, imageType);
        } else {
            map.put(DOCKER_IMAGE_TYPE_KEY, DockerImageType.NONE.toString());
        }
        map.put(SCHEMA_VERSION_KEY, this.schemaVersion);
        map.put(OS_KEY, webAppConfig.getRuntime() == null ? "" : Objects.toString(webAppConfig.getRuntime().getOperatingSystem()));
        map.put(JAVA_VERSION_KEY, webAppConfig.getRuntime() == null || webAppConfig.getRuntime().getJavaVersion() == null ? "" : webAppConfig.getRuntime().getJavaVersion().getValue());
        map.put(JAVA_WEB_CONTAINER_KEY, webAppConfig.getRuntime() == null || webAppConfig.getRuntime().getWebContainer() == null ? "" : webAppConfig.getRuntime().getWebContainer().getValue());
        try {
            map.put(DEPLOYMENT_TYPE_KEY, this.getDeploymentType().toString());
        }
        catch (AzureExecutionException e) {
            map.put(DEPLOYMENT_TYPE_KEY, "Unknown deployment type.");
        }
        map.put(DEPLOY_TO_SLOT_KEY, String.valueOf(StringUtils.isNotEmpty((CharSequence)webAppConfig.getDeploymentSlotName())));
        return map;
    }

    protected WebAppConfig getWebAppConfig() throws AzureExecutionException {
        SchemaVersion version = SchemaVersion.fromString(this.getSchemaVersion());
        AbstractConfigurationValidator validator = version == SchemaVersion.V2 ? new V2ConfigurationValidator(this) : new V1ConfigurationValidator(this);
        AbstractConfigParser parser = version == SchemaVersion.V2 ? new V2ConfigParser(this, validator) : new V1ConfigParser(this, validator);
        return parser.parse();
    }

    protected AzureAppService getOrCreateAzureAppServiceClient() throws AzureExecutionException {
        if (this.appServiceClient == null) {
            try {
                Account account = this.getAzureAccount();
                List subscriptions = account.getSubscriptions();
                String targetSubscriptionId = this.getTargetSubscriptionId(this.getSubscriptionId(), subscriptions, account.getSelectedSubscriptions());
                AbstractWebAppMojo.checkSubscription((List)subscriptions, (String)targetSubscriptionId);
                ((AzureAccount)Azure.az(AzureAccount.class)).account().selectSubscription(Collections.singletonList(targetSubscriptionId));
                this.appServiceClient = (AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(targetSubscriptionId);
                this.printCurrentSubscription(this.appServiceClient);
            }
            catch (AzureExecutionException | AzureLoginException | IOException e) {
                throw new AzureExecutionException(String.format("Cannot authenticate due to error %s", e.getMessage()), e);
            }
        }
        return this.appServiceClient;
    }

    protected void printCurrentSubscription(AzureAppService appServiceClient) {
        if (appServiceClient == null) {
            return;
        }
        Subscription subscription = appServiceClient.getDefaultSubscription();
        if (subscription != null) {
            Log.info((String)String.format("Subscription: %s(%s)", TextUtils.cyan((String)subscription.getName()), TextUtils.cyan((String)subscription.getId())));
        }
    }

    public String getSubscriptionId() {
        return this.appServiceClient == null ? this.subscriptionId : this.appServiceClient.getDefaultSubscription().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentStagingDirectoryPath() {
        if (this.stagingDirectory == null) {
            AbstractWebAppMojo abstractWebAppMojo = this;
            synchronized (abstractWebAppMojo) {
                if (this.stagingDirectory == null) {
                    String outputFolder = this.getPluginName().replaceAll("-maven-plugin", "");
                    String stagingDirectoryPath = Paths.get(this.getBuildDirectoryAbsolutePath(), outputFolder, String.format("%s-%s", this.getAppName(), UUID.randomUUID().toString())).toString();
                    this.stagingDirectory = new File(stagingDirectoryPath);
                    if (!this.stagingDirectory.exists()) {
                        this.stagingDirectory.mkdirs();
                    }
                }
            }
        }
        return this.stagingDirectory.getPath();
    }
}

