/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.queryer.MavenPluginQueryer;
import com.microsoft.azure.maven.queryer.QueryFactory;
import com.microsoft.azure.maven.utils.CustomTextIoStringListReader;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.handlers.WebAppPomHandler;
import com.microsoft.azure.maven.webapp.models.WebAppOption;
import com.microsoft.azure.maven.webapp.parser.V2NoValidationConfigurationParser;
import com.microsoft.azure.maven.webapp.utils.JavaVersionUtils;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import com.microsoft.azure.maven.webapp.utils.WebContainerUtils;
import com.microsoft.azure.maven.webapp.validator.V2ConfigurationValidator;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.DocumentException;
import rx.Observable;
import rx.schedulers.Schedulers;

@Mojo(name="config")
public class ConfigMojo
extends AbstractWebAppMojo {
    private static final String WEB_CONTAINER = "webContainer";
    private static final String JAVA_VERSION = "javaVersion";
    private static final String COMMON_PROMPT = "Define value for %s [%s]:";
    private static final String PRICING_TIER_PROMPT = "Define value for pricingTier [%s]:";
    private static final String NOT_EMPTY_REGEX = "[\\s\\S]+";
    private static final String BOOLEAN_REGEX = "[YyNn]";
    private static final String CONFIG_ONLY_SUPPORT_V2 = "Config only support V2 schema";
    private static final String CHANGE_OS_WARNING = "The plugin may not work if you change the os of an existing webapp.";
    private static final String CONFIGURATION_NO_RUNTIME = "No runtime configuration, skip it.";
    private static final String SAVING_TO_POM = "Saving configuration to pom.";
    private static final String PRICE_TIER_NOT_AVAIL = "The price tier \"P1\", \"P2\", \"P3\" are only available for Windows runtime, use \"%s\" instead.";
    private static final String NO_JAVA_WEB_APPS = "There are no Java Web Apps in current subscription, please follow the following steps to create a new one.";
    private static final String LONG_LOADING_HINT = "It may take a few minutes to load all Java Web Apps, please be patient.";
    private static final String[] configTypes = new String[]{"Application", "Runtime", "DeploymentSlot"};
    private static final String SETTING_DOCKER_IMAGE = "DOCKER_CUSTOM_IMAGE_NAME";
    private static final String SETTING_REGISTRY_SERVER = "DOCKER_REGISTRY_SERVER_URL";
    private static final String SETTING_REGISTRY_USERNAME = "DOCKER_REGISTRY_SERVER_USERNAME";
    private static final String SERVER_ID_TEMPLATE = "Please add a server in Maven settings.xml related to username: %s and put the serverId here";
    private static final List<String> WEB_APP_PROPERTIES = Arrays.asList("subscriptionId", "resourceGroup", "appName", "runtime", "deployment", "region", "appServicePlanResourceGroup", "appServicePlanName", "deploymentSlot");
    private MavenPluginQueryer queryer;
    private WebAppPomHandler pomHandler;

    protected void doExecute() throws AzureExecutionException {
        if (!(com.microsoft.azure.common.Utils.isPomPackagingProject((String)this.project.getPackaging()) || com.microsoft.azure.common.Utils.isJarPackagingProject((String)this.project.getPackaging()) || com.microsoft.azure.common.Utils.isEarPackagingProject((String)this.project.getPackaging()) || com.microsoft.azure.common.Utils.isWarPackagingProject((String)this.project.getPackaging()))) {
            throw new UnsupportedOperationException(String.format("The project (%s) with packaging %s is not supported for azure app service.", this.project.getName(), this.project.getPackaging()));
        }
        this.queryer = QueryFactory.getQueryer((Settings)this.settings);
        try {
            WebAppConfiguration configuration;
            this.pomHandler = new WebAppPomHandler(this.project.getFile().getAbsolutePath());
            WebAppConfiguration webAppConfiguration = configuration = this.pomHandler.getConfiguration() == null ? null : this.getWebAppConfigurationWithoutValidation();
            if (!this.isV2Configuration(configuration)) {
                Log.warn((String)CONFIG_ONLY_SUPPORT_V2);
            } else {
                this.config(configuration);
            }
        }
        catch (IOException | IllegalAccessException | MojoFailureException | DocumentException e) {
            throw new AzureExecutionException(e.getMessage(), e);
        }
        finally {
            this.queryer.close();
        }
    }

    private boolean isV2Configuration(WebAppConfiguration configuration) {
        return configuration == null || this.schemaVersion.equalsIgnoreCase(SchemaVersion.V2.toString());
    }

    private boolean isProjectConfigured() {
        String pluginIdentifier = this.plugin.getPluginLookupKey();
        Xpp3Dom configuration = MavenConfigUtils.getPluginConfiguration((MavenProject)this.getProject(), (String)pluginIdentifier);
        if (configuration == null) {
            return false;
        }
        for (Xpp3Dom child : configuration.getChildren()) {
            if (!WEB_APP_PROPERTIES.contains(child.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void config(WebAppConfiguration configuration) throws MojoFailureException, AzureExecutionException, IOException, IllegalAccessException {
        do {
            if (configuration == null || !this.isProjectConfigured()) {
                try {
                    result = this.chooseExistingWebappForConfiguration();
                    if (result != null) ** GOTO lbl11
                    result = this.initConfig();
                }
                catch (AzureAuthFailureException e) {
                    throw new AzureExecutionException(String.format("Cannot get Web App list due to error: %s.", new Object[]{e.getMessage()}), (Throwable)e);
                }
            } else {
                result = this.updateConfiguration(configuration.getBuilderFromConfiguration().build());
            }
lbl11:
            // 3 sources

        } while (!this.confirmConfiguration(result));
        Log.info((String)"Saving configuration to pom.");
        if (Objects.nonNull(configuration) && Objects.nonNull(result.getOs()) && Objects.nonNull(this.getRuntime())) {
            switch (1.$SwitchMap$com$microsoft$azure$common$appservice$OperatingSystemEnum[result.getOs().ordinal()]) {
                case 1: {
                    if (StringUtils.equals((CharSequence)RuntimeStackUtils.getJavaVersionFromRuntimeStack(result.getRuntimeStack()), (CharSequence)this.getRuntime().getJavaVersionRaw()) && StringUtils.equals((CharSequence)RuntimeStackUtils.getWebContainerFromRuntimeStack(result.getRuntimeStack()), (CharSequence)this.getRuntime().getWebContainerRaw())) break;
                    FieldUtils.writeField((Object)configuration, (String)"runtimeStack", null, (boolean)true);
                    break;
                }
                case 2: {
                    if (!StringUtils.equals((CharSequence)JavaVersionUtils.formatJavaVersion(result.getJavaVersion()), (CharSequence)this.getRuntime().getJavaVersionRaw())) {
                        FieldUtils.writeField((Object)configuration, (String)"javaVersion", null, (boolean)true);
                    }
                    if (StringUtils.equals((CharSequence)WebContainerUtils.formatWebContainer(result.getWebContainer()), (CharSequence)this.getRuntime().getWebContainerRaw())) break;
                    FieldUtils.writeField((Object)configuration, (String)"webContainer", null, (boolean)true);
                    break;
                }
            }
        }
        this.pomHandler.updatePluginConfiguration(result, configuration);
    }

    protected boolean confirmConfiguration(WebAppConfiguration configuration) throws AzureExecutionException, MojoFailureException {
        System.out.println("Please confirm webapp properties");
        if (StringUtils.isNotBlank((CharSequence)configuration.getSubscriptionId())) {
            System.out.println("Subscription Id : " + configuration.getSubscriptionId());
        }
        System.out.println("AppName : " + configuration.getAppName());
        System.out.println("ResourceGroup : " + configuration.getResourceGroup());
        System.out.println("Region : " + configuration.getRegion());
        System.out.println("PricingTier : " + configuration.getPricingTier());
        if (configuration.getOs() == null) {
            System.out.println(CONFIGURATION_NO_RUNTIME);
        } else {
            System.out.println("OS : " + configuration.getOs().toString());
            switch (configuration.getOs()) {
                case Windows: {
                    System.out.println("Java : " + JavaVersionUtils.formatJavaVersion(configuration.getJavaVersion()));
                    System.out.println("Web server stack: " + WebContainerUtils.formatWebContainer(configuration.getWebContainer()));
                    break;
                }
                case Linux: {
                    System.out.println("Java : " + RuntimeStackUtils.getJavaVersionFromRuntimeStack(configuration.getRuntimeStack()));
                    System.out.println("Web server stack: " + RuntimeStackUtils.getWebContainerFromRuntimeStack(configuration.getRuntimeStack()));
                    break;
                }
                case Docker: {
                    System.out.println("Image : " + configuration.getImage());
                    System.out.println("ServerId : " + configuration.getServerId());
                    System.out.println("RegistryUrl : " + configuration.getRegistryUrl());
                    break;
                }
                default: {
                    throw new AzureExecutionException("The value of <os> is unknown.");
                }
            }
        }
        System.out.println("Deploy to slot : " + (configuration.getDeploymentSlotSetting() != null));
        if (configuration.getDeploymentSlotSetting() != null) {
            DeploymentSlotSetting slotSetting = configuration.getDeploymentSlotSetting();
            System.out.println("Slot name : " + slotSetting.getName());
            System.out.println("ConfigurationSource : " + slotSetting.getConfigurationSource());
        }
        String result = this.queryer.assureInputFromUser("confirm", "Y", BOOLEAN_REGEX, "Confirm (Y/N)", null);
        return result.equalsIgnoreCase("Y");
    }

    protected WebAppConfiguration initConfig() throws MojoFailureException, AzureExecutionException {
        WebAppConfiguration result = this.getDefaultConfiguration();
        return this.getRuntimeConfiguration(result, true);
    }

    private WebAppConfiguration getDefaultConfiguration() throws AzureExecutionException {
        WebAppConfiguration.Builder builder = new WebAppConfiguration.Builder();
        String defaultName = this.getProject().getArtifactId() + "-" + System.currentTimeMillis();
        String resourceGroup = defaultName + "-rg";
        String defaultSchemaVersion = "v2";
        Region defaultRegion = WebAppConfiguration.DEFAULT_REGION;
        PricingTier pricingTier = WebAppConfiguration.DEFAULT_PRICINGTIER;
        return builder.appName(defaultName).subscriptionId(this.subscriptionId).resourceGroup(resourceGroup).region(defaultRegion).pricingTier(pricingTier).resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources()).schemaVersion("v2").subscriptionId(this.subscriptionId).build();
    }

    protected WebAppConfiguration updateConfiguration(WebAppConfiguration configuration) throws MojoFailureException, AzureExecutionException {
        String selection;
        switch (selection = this.queryer.assureInputFromUser("selection", configTypes[0], Arrays.asList(configTypes), String.format("Please choose which part to config [%s]:", configTypes[0]))) {
            case "Application": {
                return this.getWebAppConfiguration(configuration);
            }
            case "Runtime": {
                Log.warn((String)CHANGE_OS_WARNING);
                return this.getRuntimeConfiguration(configuration, false);
            }
            case "DeploymentSlot": {
                return this.getSlotConfiguration(configuration);
            }
        }
        throw new AzureExecutionException("Unknown webapp setting");
    }

    private WebAppConfiguration getWebAppConfiguration(WebAppConfiguration configuration) throws MojoFailureException {
        WebAppConfiguration.Builder builder = configuration.getBuilderFromConfiguration();
        String defaultSubscriptionId = StringUtils.isNotBlank((CharSequence)configuration.subscriptionId) ? configuration.subscriptionId : null;
        String subscriptionId = StringUtils.isNotBlank((CharSequence)defaultSubscriptionId) ? this.queryer.assureInputFromUser("subscriptionId", defaultSubscriptionId, "[a-fA-F0-9\\-]{30,36}", null, null) : null;
        String defaultAppName = this.getDefaultValue(configuration.appName, this.getProject().getArtifactId(), "[a-zA-Z0-9\\-]{2,60}");
        String appName = this.queryer.assureInputFromUser("appName", defaultAppName, "[a-zA-Z0-9\\-]{2,60}", null, null);
        String defaultResourceGroup = this.getDefaultValue(configuration.resourceGroup, String.format("%s-rg", appName), "[a-zA-Z0-9\\.\\_\\-\\(\\)]{1,90}");
        String resourceGroup = this.queryer.assureInputFromUser("resourceGroup", defaultResourceGroup, "[a-zA-Z0-9\\.\\_\\-\\(\\)]{1,90}", null, null);
        String defaultRegion = configuration.getRegionOrDefault();
        String region = this.queryer.assureInputFromUser("region", defaultRegion, NOT_EMPTY_REGEX, null, null);
        String currentPricingTier = configuration.getPricingTierOrDefault();
        List<String> availablePriceList = ConfigMojo.getAvailablePricingTierList(configuration.getOs());
        String defaultPricingTier = currentPricingTier;
        if (availablePriceList.stream().noneMatch(price -> StringUtils.equalsIgnoreCase((CharSequence)price, (CharSequence)currentPricingTier))) {
            defaultPricingTier = AppServiceUtils.convertPricingTierToString((PricingTier)WebAppConfiguration.DEFAULT_PRICINGTIER);
            Log.warn((String)String.format(PRICE_TIER_NOT_AVAIL, defaultPricingTier));
        }
        String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultPricingTier, availablePriceList, String.format(PRICING_TIER_PROMPT, defaultPricingTier));
        return builder.subscriptionId(subscriptionId).appName(appName).resourceGroup(resourceGroup).region(Region.fromName((String)region)).pricingTier(AppServiceUtils.getPricingTierFromString((String)pricingTier)).build();
    }

    private WebAppConfiguration getSlotConfiguration(WebAppConfiguration configuration) throws MojoFailureException {
        WebAppConfiguration.Builder builder = configuration.getBuilderFromConfiguration();
        DeploymentSlotSetting deploymentSlotSetting = configuration.getDeploymentSlotSetting();
        String defaultIsSlotDeploy = deploymentSlotSetting == null ? "N" : "Y";
        String isSlotDeploy = this.queryer.assureInputFromUser("isSlotDeploy", defaultIsSlotDeploy, BOOLEAN_REGEX, "Deploy to slot?(Y/N)", null);
        if (isSlotDeploy.toLowerCase().equals("n")) {
            return builder.deploymentSlotSetting(null).build();
        }
        String defaultSlotName = deploymentSlotSetting == null ? String.format("%s-slot", configuration.getAppName()) : deploymentSlotSetting.getName();
        String slotName = this.queryer.assureInputFromUser("slotName", defaultSlotName, NOT_EMPTY_REGEX, null, null);
        String defaultConfigurationSource = deploymentSlotSetting == null ? null : deploymentSlotSetting.getConfigurationSource();
        String configurationSource = this.queryer.assureInputFromUser("configurationSource", defaultConfigurationSource, null, null, null);
        DeploymentSlotSetting result = new DeploymentSlotSetting();
        result.setName(slotName);
        result.setConfigurationSource(configurationSource);
        return builder.deploymentSlotSetting(result).build();
    }

    private WebAppConfiguration getRuntimeConfiguration(WebAppConfiguration configuration, boolean initial) throws MojoFailureException, AzureExecutionException {
        WebAppConfiguration.Builder builder = configuration.getBuilderFromConfiguration();
        OperatingSystemEnum defaultOs = configuration.getOs() == null ? OperatingSystemEnum.Linux : configuration.getOs();
        String os = this.queryer.assureInputFromUser("OS", (Enum)defaultOs, String.format("Define value for OS [%s]:", defaultOs.toString()));
        builder.os(com.microsoft.azure.common.Utils.parseOperationSystem((String)os));
        if (initial || ConfigMojo.pricingTierNotSupport(com.microsoft.azure.common.Utils.parseOperationSystem((String)os), configuration.getPricingTier())) {
            String defaultPricingTier = configuration.getPricingTierOrDefault();
            List<String> availablePriceList = ConfigMojo.getAvailablePricingTierList(com.microsoft.azure.common.Utils.parseOperationSystem((String)os));
            if (!availablePriceList.contains(defaultPricingTier)) {
                Log.warn((String)String.format("'%s' is not supported in '%s'", defaultPricingTier, os));
                defaultPricingTier = AppServiceUtils.convertPricingTierToString((PricingTier)WebAppConfiguration.DEFAULT_PRICINGTIER);
            }
            String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultPricingTier, availablePriceList, String.format(PRICING_TIER_PROMPT, defaultPricingTier));
            builder.pricingTier(AppServiceUtils.getPricingTierFromString((String)pricingTier));
        }
        switch (os.toLowerCase()) {
            case "linux": {
                builder = this.getRuntimeConfigurationOfLinux(builder, configuration);
                break;
            }
            case "windows": {
                builder = this.getRuntimeConfigurationOfWindows(builder, configuration);
                break;
            }
            case "docker": {
                builder = this.getRuntimeConfigurationOfDocker(builder, configuration);
                break;
            }
            default: {
                throw new AzureExecutionException("The value of <os> is unknown.");
            }
        }
        return builder.build();
    }

    private static boolean pricingTierNotSupport(OperatingSystemEnum parseOperationSystem, PricingTier pricingTier) {
        List<String> availablePriceList = ConfigMojo.getAvailablePricingTierList(parseOperationSystem);
        return Objects.isNull(Utils.findStringInCollectionIgnoreCase(availablePriceList, AppServiceUtils.convertPricingTierToString((PricingTier)pricingTier)));
    }

    private WebAppConfiguration.Builder getRuntimeConfigurationOfLinux(WebAppConfiguration.Builder builder, WebAppConfiguration configuration) throws MojoFailureException {
        String defaultJavaVersion = configuration.getLinuxJavaVersionOrDefault();
        if (Objects.isNull(configuration.getRuntimeStack()) && Objects.nonNull(this.getRuntime()) && Objects.nonNull(this.getRuntime().getJavaVersion())) {
            defaultJavaVersion = JavaVersionUtils.formatJavaVersion(this.getRuntime().getJavaVersion());
        }
        String javaVersion = this.queryer.assureInputFromUser(JAVA_VERSION, defaultJavaVersion, JavaVersionUtils.getValidJavaVersions(), String.format(COMMON_PROMPT, JAVA_VERSION, defaultJavaVersion));
        if (this.isJarProject()) {
            return builder.runtimeStack(RuntimeStackUtils.getJavaSERuntimeStack(javaVersion));
        }
        List<String> validRuntimeStacks = RuntimeStackUtils.getValidLinuxRuntimeStacksForJavaVersion(javaVersion);
        String defaultLinuxRuntimeStack = configuration.getLinuxRuntimeStackOrDefault();
        if (Objects.isNull(configuration.getRuntimeStack()) && Objects.nonNull(this.getRuntime()) && StringUtils.isNotBlank((CharSequence)this.getRuntime().getWebContainerRaw())) {
            String validRuntStackFromExistingConfiguration = Utils.findStringInCollectionIgnoreCase(validRuntimeStacks, this.getRuntime().getWebContainerRaw());
            if (validRuntStackFromExistingConfiguration == null) {
                Log.warn((String)String.format("Invalid webContainer '%s' for java version: %s", this.getRuntime().getWebContainerRaw(), javaVersion));
            } else {
                defaultLinuxRuntimeStack = validRuntStackFromExistingConfiguration;
            }
        } else if (Objects.isNull(Utils.findStringInCollectionIgnoreCase(validRuntimeStacks, defaultLinuxRuntimeStack))) {
            Log.warn((String)String.format("'%s' is not supported in java version: %s", defaultLinuxRuntimeStack, javaVersion));
            defaultLinuxRuntimeStack = WebAppConfiguration.DEFAULT_LINUX_WEB_CONTAINER;
        }
        String runtimeStack = this.queryer.assureInputFromUser("runtimeStack", defaultLinuxRuntimeStack, validRuntimeStacks, null);
        return builder.runtimeStack(RuntimeStackUtils.getRuntimeStack(javaVersion, runtimeStack));
    }

    private WebAppConfiguration.Builder getRuntimeConfigurationOfWindows(WebAppConfiguration.Builder builder, WebAppConfiguration configuration) throws MojoFailureException {
        String defaultJavaVersion = JavaVersionUtils.formatJavaVersion(configuration.getJavaVersionOrDefault());
        List<String> validJavaVersions = JavaVersionUtils.getValidJavaVersions();
        if (!validJavaVersions.contains(defaultJavaVersion)) {
            Log.warn((String)String.format("'%s' is not supported.", defaultJavaVersion));
            defaultJavaVersion = WebAppConfiguration.DEFAULT_LINUX_JAVA_VERSION;
        }
        String javaVersionInput = this.queryer.assureInputFromUser(JAVA_VERSION, defaultJavaVersion, validJavaVersions, String.format(COMMON_PROMPT, JAVA_VERSION, defaultJavaVersion));
        JavaVersion javaVersion = JavaVersionUtils.toAzureSdkJavaVersion(javaVersionInput);
        if (this.isJarProject()) {
            WebContainer webContainer = WebContainerUtils.getJavaSEWebContainer();
            return builder.javaVersion(javaVersion).webContainer(webContainer);
        }
        String defaultWebContainer = configuration.getWebContainerOrDefault();
        String webContainerInput = this.queryer.assureInputFromUser(WEB_CONTAINER, defaultWebContainer, WebContainerUtils.getAvailableWebContainer(), String.format(COMMON_PROMPT, WEB_CONTAINER, defaultWebContainer));
        return builder.javaVersion(javaVersion).webContainer(WebContainer.fromString((String)webContainerInput));
    }

    private WebAppConfiguration.Builder getRuntimeConfigurationOfDocker(WebAppConfiguration.Builder builder, WebAppConfiguration configuration) throws MojoFailureException {
        String image = this.queryer.assureInputFromUser("image", configuration.image, NOT_EMPTY_REGEX, null, null);
        String serverId = this.queryer.assureInputFromUser("serverId", configuration.serverId, null, null, null);
        String registryUrl = this.queryer.assureInputFromUser("registryUrl", configuration.registryUrl, null, null, null);
        return builder.image(image).serverId(serverId).registryUrl(registryUrl);
    }

    private static List<String> getAvailablePricingTierList(OperatingSystemEnum operatingSystem) {
        HashSet<String> pricingTierSet = new HashSet<String>();
        List availablePricingTier = AppServiceUtils.getAvailablePricingTiers((OperatingSystem)(operatingSystem == OperatingSystemEnum.Windows ? OperatingSystem.WINDOWS : OperatingSystem.LINUX));
        for (PricingTier pricingTier : availablePricingTier) {
            pricingTierSet.add(pricingTier.toSkuDescription().size());
        }
        ArrayList<String> result = new ArrayList<String>(pricingTierSet);
        Collections.sort(result);
        return result;
    }

    private String getDefaultValue(String defaultValue, String fallBack, String pattern) {
        return StringUtils.isNotEmpty((CharSequence)defaultValue) && defaultValue.matches(pattern) ? defaultValue : fallBack;
    }

    private boolean isJarProject() {
        return com.microsoft.azure.common.Utils.isJarPackagingProject((String)this.project.getPackaging());
    }

    private WebAppConfiguration getWebAppConfigurationWithoutValidation() throws AzureExecutionException {
        return new V2NoValidationConfigurationParser(this, new V2ConfigurationValidator(this)).getWebAppConfiguration();
    }

    private WebAppConfiguration chooseExistingWebappForConfiguration() throws AzureExecutionException, AzureAuthFailureException {
        try {
            Azure az = this.getOrCreateAzureClient();
            if (Objects.isNull(az)) {
                return null;
            }
            Subscription targetSubscription = az.getCurrentSubscription();
            if (Objects.isNull(targetSubscription)) {
                return null;
            }
            this.subscriptionId = targetSubscription.subscriptionId();
            WebAppsInner webappClient = ((WebSiteManagementClientImpl)((AppServiceManager)az.webApps().manager()).inner()).webApps();
            List siteInners = webappClient.list().stream().filter(site -> site.kind() != null && !Arrays.asList(site.kind().split(",")).contains("functionapp")).map(t -> new WebAppOption((SiteInner)t, webappClient)).sorted().collect(Collectors.toList());
            if (siteInners.isEmpty()) {
                Log.warn((String)NO_JAVA_WEB_APPS);
                return null;
            }
            Log.info((String)LONG_LOADING_HINT);
            Observable.from(siteInners).flatMap(WebAppOption::loadConfigurationSync, siteInners.size()).subscribeOn(Schedulers.io()).toBlocking().subscribe();
            boolean isContainer = !com.microsoft.azure.common.Utils.isJarPackagingProject((String)this.project.getPackaging());
            boolean isDockerOnly = com.microsoft.azure.common.Utils.isPomPackagingProject((String)this.project.getPackaging());
            List<WebAppOption> javaOrDockerWebapps = siteInners.stream().filter(app -> app.isJavaWebApp() || app.isDockerWebapp()).filter(app -> ConfigMojo.checkWebAppVisible(isContainer, isDockerOnly, app.isJavaSE(), app.isDockerWebapp())).sorted().collect(Collectors.toList());
            TextIO textIO = TextIoFactory.getTextIO();
            WebAppOption selectedApp = ConfigMojo.selectAzureWebApp(textIO, javaOrDockerWebapps, ConfigMojo.getWebAppTypeByPackaging(this.project.getPackaging()), targetSubscription);
            if (selectedApp == null || selectedApp.isCreateNew()) {
                return null;
            }
            WebApp webapp = (WebApp)((AppServiceManager)az.webApps().manager()).webApps().getById(selectedApp.getId());
            String serverPlanId = selectedApp.getServicePlanId();
            AppServicePlan servicePlan = null;
            if (StringUtils.isNotBlank((CharSequence)serverPlanId)) {
                servicePlan = (AppServicePlan)((AppServiceManager)az.webApps().manager()).appServicePlans().getById(serverPlanId);
            }
            WebAppConfiguration.Builder builder = new WebAppConfiguration.Builder();
            if (!AppServiceUtils.isDockerAppService((WebAppBase)webapp)) {
                builder.resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources());
            }
            return ConfigMojo.getConfigurationFromExisting(webapp, servicePlan, builder);
        }
        catch (AzureToolkitAuthenticationException ex) {
            this.getLog().warn((CharSequence)String.format("Cannot authenticate due to error: %s, select existing webapp is skipped.", ex.getMessage()));
            return null;
        }
    }

    private static WebAppOption selectAzureWebApp(TextIO textIO, List<WebAppOption> javaOrDockerWebapps, String webAppType, Subscription targetSubscription) {
        ArrayList<WebAppOption> options = new ArrayList<WebAppOption>();
        options.add(WebAppOption.CREATE_NEW);
        if (javaOrDockerWebapps.isEmpty()) {
            Log.warn((String)NO_JAVA_WEB_APPS);
            return null;
        }
        options.addAll(javaOrDockerWebapps);
        return (WebAppOption)((GenericInputReader)((GenericInputReader)new CustomTextIoStringListReader(() -> textIO.getTextTerminal(), null).withCustomPrompt(String.format("Please choose a %s Web App%s: ", webAppType, ConfigMojo.highlightDefaultValue((String)WebAppOption.CREATE_NEW.toString()))).withNumberedPossibleValues(options)).withDefaultValue((Object)WebAppOption.CREATE_NEW)).read(new String[]{String.format("%s Web Apps in subscription %s:", webAppType, TextUtils.blue((String)targetSubscription.displayName()))});
    }

    private static WebAppConfiguration getConfigurationFromExisting(WebApp webapp, AppServicePlan servicePlan, WebAppConfiguration.Builder builder) {
        builder.appName(webapp.name()).resourceGroup(webapp.resourceGroupName()).subscriptionId(com.microsoft.azure.common.Utils.getSubscriptionId((String)webapp.id())).region(webapp.region());
        if (AppServiceUtils.isDockerAppService((WebAppBase)webapp)) {
            AppSetting dockerUsernameSetting;
            builder.os(OperatingSystemEnum.Docker);
            Map settings = webapp.getAppSettings();
            AppSetting imageSetting = (AppSetting)settings.get(SETTING_DOCKER_IMAGE);
            if (imageSetting != null && StringUtils.isNotBlank((CharSequence)imageSetting.value())) {
                builder.image(imageSetting.value());
            } else {
                builder.image(ConfigMojo.getDockerImageName(webapp.linuxFxVersion()));
            }
            AppSetting registryServerSetting = (AppSetting)settings.get(SETTING_REGISTRY_SERVER);
            if (registryServerSetting != null && StringUtils.isNotBlank((CharSequence)registryServerSetting.value())) {
                builder.registryUrl(registryServerSetting.value());
            }
            if ((dockerUsernameSetting = (AppSetting)settings.get(SETTING_REGISTRY_USERNAME)) != null && StringUtils.isNotBlank((CharSequence)dockerUsernameSetting.value())) {
                builder.serverId(String.format(SERVER_ID_TEMPLATE, dockerUsernameSetting.value()));
            }
            builder.os(OperatingSystemEnum.Docker);
        } else if (webapp.operatingSystem() == OperatingSystem.LINUX) {
            builder.os(OperatingSystemEnum.Linux);
            RuntimeStack runtimeStack = AppServiceUtils.parseRuntimeStack((String)webapp.linuxFxVersion());
            builder.runtimeStack(runtimeStack);
        } else {
            builder.os(OperatingSystemEnum.Windows);
            WebContainer webContainer = WebContainer.fromString((String)(webapp.javaContainer() + " " + webapp.javaContainerVersion()));
            builder.javaVersion(webapp.javaVersion());
            builder.webContainer(webContainer);
        }
        if (servicePlan != null) {
            builder.pricingTier(servicePlan.pricingTier());
            builder.servicePlanName(servicePlan.name());
            builder.servicePlanResourceGroup(servicePlan.resourceGroupName());
        }
        return builder.build();
    }

    private static String getDockerImageName(String linuxFxVersion) {
        String[] segments = linuxFxVersion.split(Pattern.quote("|"));
        if (segments.length != 2) {
            return null;
        }
        String image = segments[1];
        if (!image.contains("/")) {
            return image;
        }
        segments = image.split(Pattern.quote("/"));
        return segments[segments.length - 1].trim();
    }

    private static boolean checkWebAppVisible(boolean isContainer, boolean isDockerOnly, boolean isJavaSEWebApp, boolean isDockerWebapp) {
        if (isDockerWebapp) {
            return true;
        }
        if (isDockerOnly) {
            return false;
        }
        if (isContainer) {
            return !isJavaSEWebApp;
        }
        return isJavaSEWebApp;
    }

    private static String getWebAppTypeByPackaging(String packaging) {
        boolean isContainer = !com.microsoft.azure.common.Utils.isJarPackagingProject((String)packaging);
        boolean isDockerOnly = com.microsoft.azure.common.Utils.isPomPackagingProject((String)packaging);
        if (isDockerOnly) {
            return "Docker";
        }
        if (isContainer) {
            return "Web Container";
        }
        return "Java SE";
    }
}

