/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.configuration;

import com.microsoft.azure.common.Utils;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.webapp.utils.JavaVersionUtils;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import com.microsoft.azure.maven.webapp.utils.WebContainerUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MavenRuntimeConfig {
    protected String os;
    protected String javaVersion;
    protected String webContainer;
    protected String image;
    protected String serverId;
    protected String registryUrl;
    public static final String RUNTIME_CONFIG_REFERENCE = "https://aka.ms/maven_webapp_runtime";

    public String getOs() {
        return this.os;
    }

    public OperatingSystemEnum getOsEnum() {
        try {
            return Utils.parseOperationSystem((String)this.os);
        }
        catch (AzureExecutionException e) {
            return null;
        }
    }

    public JavaVersion getJavaVersion() {
        JavaVersion ver = JavaVersionUtils.toAzureSdkJavaVersion(this.javaVersion);
        if (Objects.nonNull(ver)) {
            return ver;
        }
        return StringUtils.isEmpty((CharSequence)this.javaVersion) || !this.checkJavaVersion(this.javaVersion) ? null : JavaVersion.fromString((String)this.javaVersion);
    }

    public RuntimeStack getLinuxRuntime() {
        return RuntimeStackUtils.getRuntimeStack(this.javaVersion, this.webContainer);
    }

    public WebContainer getWebContainer() {
        if (!this.checkWebContainer(this.webContainer)) {
            return null;
        }
        return WebContainerUtils.parseWebContainer(this.webContainer, this.getJavaVersion());
    }

    public String getWebContainerRaw() {
        return this.webContainer;
    }

    public String getJavaVersionRaw() {
        return this.javaVersion;
    }

    public String getImage() {
        return this.image;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.os) && StringUtils.isEmpty((CharSequence)this.javaVersion) && StringUtils.isEmpty((CharSequence)this.webContainer) && StringUtils.isEmpty((CharSequence)this.image) && StringUtils.isEmpty((CharSequence)this.serverId) && StringUtils.isEmpty((CharSequence)this.registryUrl);
    }

    protected boolean checkJavaVersion(String value) {
        for (JavaVersion version : JavaVersion.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)version.toString(), (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkWebContainer(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && (WebContainerUtils.isJavaSeWebContainer(value) || Objects.nonNull(WebContainerUtils.parseNonJavaSEWebContainer(value)));
    }
}

