/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.serializer.ConfigurationSerializer;
import com.microsoft.azure.maven.webapp.serializer.V2ConfigurationSerializer;
import com.microsoft.azure.maven.webapp.utils.XMLUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Properties;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class WebAppPomHandler {
    public static final String PLUGIN_GROUP_ID = "com.microsoft.azure";
    public static final String PLUGIN_ARTIFACT_ID = "azure-webapp-maven-plugin";
    public static final String PLUGIN_PROPERTIES_FILE = "plugin.properties";
    public static final String PROPERTY_VERSION = "project.version";
    final File file;
    final Document document;

    public WebAppPomHandler(String fileName) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.file = new File(fileName);
        this.document = reader.read(this.file);
    }

    public Element getConfiguration() {
        Element mavenPlugin = this.getMavenPluginElement();
        return mavenPlugin == null ? null : mavenPlugin.element("configuration");
    }

    public void updatePluginConfiguration(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs) throws IOException, MojoFailureException {
        Element pluginElement = this.getMavenPluginElement();
        if (pluginElement == null) {
            Element buildNode = XMLUtils.getOrCreateSubElement("build", this.document.getRootElement());
            Element pluginsRootNode = XMLUtils.getOrCreateSubElement("plugins", buildNode);
            pluginElement = WebAppPomHandler.createNewMavenPluginNode(pluginsRootNode);
        }
        Element configuration = XMLUtils.getOrCreateSubElement("configuration", pluginElement);
        V2ConfigurationSerializer serializer = new V2ConfigurationSerializer(newConfigs, oldConfigs);
        ((ConfigurationSerializer)serializer).saveToXML(configuration);
        XMLUtils.setNamespace(pluginElement, pluginElement.getNamespace());
        this.saveModel();
    }

    private void saveModel() throws IOException {
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(this.file), OutputFormat.createPrettyPrint());
        writer.setEscapeText(false);
        writer.write(this.document);
        writer.close();
    }

    private Element getMavenPluginElement() {
        try {
            Element pluginsRoot = this.document.getRootElement().element("build").element("plugins");
            for (Element element : pluginsRoot.elements()) {
                String groupId = XMLUtils.getChildValue("groupId", element);
                String artifactId = XMLUtils.getChildValue("artifactId", element);
                if (!PLUGIN_GROUP_ID.equals(groupId) || !PLUGIN_ARTIFACT_ID.equals(artifactId)) continue;
                return element;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    private static Element createNewMavenPluginNode(Element pluginsRootNode) throws IOException {
        DOMElement result = new DOMElement("plugin");
        result.setNamespace(pluginsRootNode.getNamespace());
        result.add((Element)XMLUtils.createSimpleElement("groupId", PLUGIN_GROUP_ID));
        result.add((Element)XMLUtils.createSimpleElement("artifactId", PLUGIN_ARTIFACT_ID));
        result.add((Element)XMLUtils.createSimpleElement("version", WebAppPomHandler.getPluginVersion()));
        pluginsRootNode.add((Element)result);
        return result;
    }

    private static String getPluginVersion() throws IOException {
        Properties properties = new Properties();
        try (InputStream is = WebAppPomHandler.class.getClassLoader().getResourceAsStream(PLUGIN_PROPERTIES_FILE);){
            properties.load(is);
            String string = properties.getProperty(PROPERTY_VERSION);
            return string;
        }
    }
}

