/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.project.IProject;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.ProjectUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.parser.AbstractConfigParser;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public class V1ConfigParser
extends AbstractConfigParser {
    public V1ConfigParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        super(mojo, validator);
    }

    @Override
    public Region getRegion() throws AzureExecutionException {
        this.validate(this.validator::validateRegion);
        if (StringUtils.isEmpty((CharSequence)this.mojo.getRegion())) {
            return Region.EUROPE_WEST;
        }
        return Region.fromName((String)this.mojo.getRegion());
    }

    @Override
    public DockerConfiguration getDockerConfiguration() throws AzureExecutionException {
        OperatingSystem os = this.getOs();
        if (os != OperatingSystem.DOCKER) {
            return null;
        }
        this.validate(this.validator::validateImage);
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        MavenDockerCredentialProvider credentialProvider = this.getDockerCredential(containerSetting.getServerId());
        return DockerConfiguration.builder().registryUrl(containerSetting.getRegistryUrl()).image(containerSetting.getImageName()).userName(credentialProvider.getUsername()).password(credentialProvider.getPassword()).build();
    }

    @Override
    public List<WebAppArtifact> getMavenArtifacts() throws AzureExecutionException {
        switch (this.mojo.getDeploymentType()) {
            case JAR: {
                return Arrays.asList(WebAppArtifact.builder().file(this.getFileToDeploy(this.mojo.getJarFile())).deployType(DeployType.JAR).build());
            }
            case WAR: {
                return Arrays.asList(WebAppArtifact.builder().file(this.getFileToDeploy(this.mojo.getWarFile())).deployType(DeployType.JAR).build());
            }
        }
        return V1ConfigParser.parseArtifactsFromResources(this.mojo.getResources());
    }

    @Override
    public Runtime getRuntime() throws AzureExecutionException {
        OperatingSystem os = this.getOs();
        switch (os) {
            case WINDOWS: {
                return this.getRuntimeForWindows();
            }
            case LINUX: {
                return this.getRuntimeForLinux();
            }
            case DOCKER: {
                return Runtime.DOCKER;
            }
        }
        return null;
    }

    private Runtime getRuntimeForWindows() throws AzureExecutionException {
        this.validate(this.validator::validateJavaVersion);
        this.validate(this.validator::validateWebContainer);
        WebContainer webContainer = WebContainer.fromString((String)this.mojo.getJavaWebContainer().toString());
        JavaVersion javaVersion = JavaVersion.fromString((String)this.mojo.getJavaVersion());
        return Runtime.getRuntime((OperatingSystem)OperatingSystem.WINDOWS, (WebContainer)webContainer, (JavaVersion)javaVersion);
    }

    private Runtime getRuntimeForLinux() throws AzureExecutionException {
        this.validate(this.validator::validateRuntimeStack);
        return Runtime.getRuntimeFromLinuxFxVersion((String)this.mojo.getLinuxRuntime());
    }

    private OperatingSystem getOs() throws AzureExecutionException {
        this.validate(this.validator::validateOs);
        String linuxRuntime = this.mojo.getLinuxRuntime();
        String javaVersion = this.mojo.getJavaVersion();
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        boolean isContainerSettingEmpty = containerSetting == null || containerSetting.isEmpty();
        ArrayList<OperatingSystem> osList = new ArrayList<OperatingSystem>();
        if (javaVersion != null) {
            osList.add(OperatingSystem.WINDOWS);
        }
        if (linuxRuntime != null) {
            osList.add(OperatingSystem.LINUX);
        }
        if (!isContainerSettingEmpty) {
            osList.add(OperatingSystem.DOCKER);
        }
        return osList.size() > 0 ? (OperatingSystem)osList.get(0) : null;
    }

    private File getFileToDeploy(String filePath) {
        IProject project = ProjectUtils.convertCommonProject((MavenProject)this.mojo.getProject());
        return StringUtils.isEmpty((CharSequence)filePath) ? project.getArtifactFile().toFile() : new File(filePath);
    }
}

