/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.webapp.utils.FTPUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.maven.model.Resource;

public class DeployUtils {
    private static final Path FTP_ROOT = Paths.get("/site/wwwroot", new String[0]);
    private static final String DEFAULT_APP_SERVICE_JAR_NAME = "app.jar";
    private static final String WEB_CONFIG = "web.config";
    private static final String RENAMING_MESSAGE = "Renaming %s to %s";
    private static final String RENAMING_FAILED_MESSAGE = "Failed to rename artifact to %s, which is required in Java SE environment, refer to https://docs.microsoft.com/en-us/azure/app-service/containers/configure-language-java#set-java-runtime-options for details.";
    private static final String NO_EXECUTABLE_JAR = "No executable jar found in target folder according to resource filter in <resource>, please make sure the resource filter is correct and you have built the jar.";
    private static final String MULTI_EXECUTABLE_JARS = "Multi executable jars found in <resources>, please check the configuration";

    public static boolean isExternalResource(Resource resource) {
        Path target = Paths.get(DeployUtils.getAbsoluteTargetPath(resource.getTargetPath()), new String[0]);
        return !target.startsWith(FTP_ROOT);
    }

    public static void deployResourcesWithFtp(IAppService appService, List<Resource> externalResources) throws AzureExecutionException {
        if (externalResources.isEmpty()) {
            return;
        }
        PublishingProfile publishingProfile = appService.getPublishingProfile();
        String serverUrl = publishingProfile.getFtpUrl().split("/", 2)[0];
        try {
            FTPClient ftpClient = FTPUtils.getFTPClient(serverUrl, publishingProfile.getFtpUsername(), publishingProfile.getFtpPassword());
            for (Resource externalResource : externalResources) {
                DeployUtils.uploadResource(externalResource, ftpClient);
            }
        }
        catch (IOException e) {
            throw new AzureExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isAllWarArtifacts(List<WebAppArtifact> webAppArtifacts) {
        Set deployTypes = webAppArtifacts.stream().map(WebAppArtifact::getDeployType).collect(Collectors.toSet());
        return deployTypes.size() == 1 && deployTypes.iterator().next() == DeployType.WAR;
    }

    private static void uploadResource(Resource resource, FTPClient ftpClient) throws IOException {
        List<File> files = Utils.getArtifacts(resource);
        String target = DeployUtils.getAbsoluteTargetPath(resource.getTargetPath());
        for (File file : files) {
            FTPUtils.uploadFile(ftpClient, file.getPath(), target);
        }
    }

    public static String getAbsoluteTargetPath(String targetPath) {
        return StringUtils.startsWith((CharSequence)(targetPath = StringUtils.defaultString((String)targetPath)), (CharSequence)"/") ? targetPath : FTP_ROOT.resolve(Paths.get(targetPath, new String[0])).normalize().toString();
    }

    public static void prepareJavaSERuntimeJarArtifact(List<File> artifacts, String finalName) throws AzureExecutionException {
        if (DeployUtils.existsWebConfig(artifacts)) {
            return;
        }
        File artifact = DeployUtils.getProjectJarArtifact(artifacts, finalName);
        File renamedArtifact = new File(artifact.getParent(), DEFAULT_APP_SERVICE_JAR_NAME);
        if (!StringUtils.equals((CharSequence)artifact.getName(), (CharSequence)DEFAULT_APP_SERVICE_JAR_NAME)) {
            Log.info((String)String.format(RENAMING_MESSAGE, artifact.getAbsolutePath(), DEFAULT_APP_SERVICE_JAR_NAME));
            if (!artifact.renameTo(renamedArtifact)) {
                throw new AzureExecutionException(String.format(RENAMING_FAILED_MESSAGE, DEFAULT_APP_SERVICE_JAR_NAME));
            }
        }
    }

    private static File getProjectJarArtifact(List<File> artifacts, String finalName) throws AzureExecutionException {
        List executableArtifacts = artifacts.stream().filter(file -> DeployUtils.isExecutableJar(file)).collect(Collectors.toList());
        File finalArtifact = executableArtifacts.stream().filter(file -> StringUtils.equals((CharSequence)finalName, (CharSequence)file.getName())).findFirst().orElse(null);
        if (executableArtifacts.size() == 0) {
            throw new AzureExecutionException(NO_EXECUTABLE_JAR);
        }
        if (finalArtifact == null && executableArtifacts.size() > 1) {
            throw new AzureExecutionException(MULTI_EXECUTABLE_JARS);
        }
        return finalArtifact == null ? (File)executableArtifacts.get(0) : finalArtifact;
    }

    private static boolean existsWebConfig(List<File> artifacts) {
        return artifacts.stream().anyMatch(file -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)WEB_CONFIG));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isExecutableJar(File file) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getExtension((String)file.getName()), (CharSequence)"jar")) {
            return false;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl;
            try (JarInputStream jarInputStream = new JarInputStream(fileInputStream);){
                Manifest manifest = jarInputStream.getManifest();
                bl = manifest != null && manifest.getMainAttributes().getValue("Main-Class") != null;
            }
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

