/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.maven.webapp.models.JavaVersionEnum;
import com.microsoft.azure.maven.webapp.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JavaVersionUtils {
    static final String JAVA_11_STRING = "java 11";
    static final String JAVA_SE = "Java SE";
    static final String JAVA = "JAVA";
    private static final String JAVA_1_8 = "1.8";
    private static final String JAVA_1_7 = "1.7";
    private static final String JAVA_11 = "11";
    private static final String JAVA_SHORT_VERSION_7 = "java7";
    private static final String JAVA_SHORT_VERSION_8 = "java8";
    private static final String JAVA_SHORT_VERSION_11 = "java11";
    private static final List<String> JAVA_VERSIONS = new ArrayList<String>();

    public static JavaVersionEnum toJavaVersionEnum(JavaVersion javaVersion) {
        if (Objects.isNull(javaVersion)) {
            return null;
        }
        String version = javaVersion.toString();
        if (StringUtils.startsWith((CharSequence)version, (CharSequence)JAVA_1_7)) {
            return JavaVersionEnum.JAVA_7;
        }
        if (StringUtils.startsWith((CharSequence)version, (CharSequence)JAVA_1_8)) {
            return JavaVersionEnum.JAVA_8;
        }
        if (StringUtils.startsWith((CharSequence)version, (CharSequence)JAVA_11)) {
            return JavaVersionEnum.JAVA_11;
        }
        return null;
    }

    public static JavaVersion toAzureSdkJavaVersion(String javaVersion) {
        if (StringUtils.isEmpty((CharSequence)javaVersion)) {
            return null;
        }
        JavaVersionEnum newEnum = JavaVersionUtils.parseJavaVersionEnum(javaVersion);
        if (newEnum == null) {
            throw new IllegalArgumentException(String.format("Cannot parse java version: '%s'.", javaVersion));
        }
        switch (newEnum) {
            case JAVA_7: {
                return JavaVersion.JAVA_7_NEWEST;
            }
            case JAVA_8: {
                return JavaVersion.JAVA_8_NEWEST;
            }
            case JAVA_11: {
                return JavaVersion.JAVA_11;
            }
        }
        throw new IllegalArgumentException(String.format("Java version '%s' is not supported.", javaVersion));
    }

    public static String formatJavaVersion(JavaVersion javaVersion) {
        if (Objects.isNull(javaVersion)) {
            return null;
        }
        return Objects.toString((Object)JavaVersionUtils.toJavaVersionEnum(javaVersion));
    }

    public static boolean equalsJavaVersion(String version1, String version2) {
        return JavaVersionUtils.parseJavaVersionEnum(version1) == JavaVersionUtils.parseJavaVersionEnum(version2);
    }

    private static String getShortJavaVersion(String javaVersion) {
        if (Objects.isNull(javaVersion)) {
            return null;
        }
        String version = StringUtils.lowerCase((String)javaVersion);
        if (version.contains("jre")) {
            version = version.replaceFirst("jre", "java");
        }
        return version.replaceAll("\\s+", "");
    }

    public static JavaVersionEnum parseJavaVersionEnum(String javaVersion) {
        if (StringUtils.isEmpty((CharSequence)javaVersion)) {
            return null;
        }
        String javaVersionInEum = Utils.findStringInCollectionIgnoreCase(JavaVersion.values().stream().map(Object::toString).collect(Collectors.toList()), javaVersion);
        if (Objects.nonNull(javaVersionInEum)) {
            return JavaVersionUtils.toJavaVersionEnum(JavaVersion.fromString((String)javaVersionInEum));
        }
        switch (JavaVersionUtils.getShortJavaVersion(javaVersion)) {
            case "1.7": 
            case "java7": {
                return JavaVersionEnum.JAVA_7;
            }
            case "1.8": 
            case "8": 
            case "java8": {
                return JavaVersionEnum.JAVA_8;
            }
            case "11": 
            case "java11": {
                return JavaVersionEnum.JAVA_11;
            }
        }
        return null;
    }

    public static List<String> getValidJavaVersions() {
        return JAVA_VERSIONS;
    }

    public static String formatJavaVersion(String javaVersion) {
        return Objects.toString((Object)JavaVersionUtils.parseJavaVersionEnum(javaVersion));
    }

    static {
        JAVA_VERSIONS.add(JavaVersionEnum.JAVA_8.toString());
        JAVA_VERSIONS.add(JavaVersionEnum.JAVA_11.toString());
    }
}

