/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.webapp.models.JavaVersionEnum;
import com.microsoft.azure.maven.webapp.utils.JavaVersionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class WebContainerUtils {
    public static WebContainer getJavaSEWebContainer() {
        return WebContainer.fromString((String)"Java SE");
    }

    public static String formatWebContainer(WebContainer webContainer) {
        if (Objects.isNull(webContainer)) {
            return null;
        }
        if (WebContainerUtils.isJavaSeWebContainer(Objects.toString(webContainer))) {
            return "Java SE";
        }
        return StringUtils.capitalize((String)webContainer.toString());
    }

    public static boolean isJavaSeWebContainer(String webContainer) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)webContainer, (CharSequence[])new CharSequence[]{"java 11", "Java SE", "JAVA", WebContainer.JAVA_8.toString()});
    }

    public static WebContainer parseNonJavaSEWebContainer(String webContainer) {
        List fields = FieldUtils.getAllFieldsList(WebContainer.class).stream().filter(field -> Modifier.isStatic(field.getModifiers()) && field.getName().contains("NEWEST")).map(field -> {
            try {
                return FieldUtils.readStaticField((Field)field);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(field -> field instanceof WebContainer).collect(Collectors.toList());
        for (WebContainer webContainerEnum : WebContainer.values()) {
            if (StringUtils.containsIgnoreCase((CharSequence)webContainerEnum.toString(), (CharSequence)"JAVA") || StringUtils.containsIgnoreCase((CharSequence)webContainerEnum.toString(), (CharSequence)"jetty") || fields.indexOf(webContainerEnum) < 0 || !StringUtils.equalsIgnoreCase((CharSequence)WebContainerUtils.formatWebContainer(webContainerEnum), (CharSequence)webContainer)) continue;
            return webContainerEnum;
        }
        return null;
    }

    public static WebContainer parseWebContainer(String webContainer, JavaVersion javaVersion) {
        if (StringUtils.isBlank((CharSequence)webContainer)) {
            return null;
        }
        if (WebContainerUtils.isJavaSeWebContainer(webContainer)) {
            JavaVersionEnum javaVersionEnum = JavaVersionUtils.toJavaVersionEnum(javaVersion);
            if (Objects.nonNull((Object)javaVersionEnum)) {
                switch (javaVersionEnum) {
                    case JAVA_8: {
                        return WebContainer.JAVA_8;
                    }
                    case JAVA_11: {
                        return WebContainer.fromString((String)"java 11");
                    }
                }
                throw new IllegalArgumentException(String.format("Java version '%s' is not supported.", javaVersion));
            }
            return null;
        }
        return WebContainerUtils.parseNonJavaSEWebContainer(webContainer);
    }

    public static List<String> getAvailableWebContainer() {
        ArrayList<String> result = new ArrayList<String>();
        List fields = FieldUtils.getAllFieldsList(WebContainer.class).stream().filter(field -> Modifier.isStatic(field.getModifiers()) && field.getName().contains("NEWEST")).map(field -> {
            try {
                return FieldUtils.readStaticField((Field)field);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(field -> field instanceof WebContainer).collect(Collectors.toList());
        for (WebContainer webContainer : WebContainer.values()) {
            if (StringUtils.containsIgnoreCase((CharSequence)webContainer.toString(), (CharSequence)"JAVA") || StringUtils.containsIgnoreCase((CharSequence)webContainer.toString(), (CharSequence)"jetty") || fields.indexOf(webContainer) < 0) continue;
            result.add(WebContainerUtils.formatWebContainer(webContainer));
        }
        Collections.sort(result);
        return result;
    }

    static {
        WebContainer.fromString((String)"Java SE");
        WebContainer.fromString((String)"java 11");
    }
}

