/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.validator;

import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.MavenRuntimeConfig;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class V2ConfigurationValidator
extends AbstractConfigurationValidator {
    public static final String[] VALID_OS = new String[]{"windows", "linux", "docker"};

    public V2ConfigurationValidator(AbstractWebAppMojo mojo) {
        super(mojo);
    }

    @Override
    public String validateRegion() {
        String region = this.mojo.getRegion();
        if (!StringUtils.isEmpty((CharSequence)region) && Region.fromName((String)region) == null) {
            return "The value of <region> is not supported, please correct it in pom.xml.";
        }
        return null;
    }

    @Override
    public String validateOs() {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        String os = StringUtils.lowerCase((String)runtime.getOs());
        if (runtime.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)os)) {
            return "Pleas configure the <os> of <runtime> in pom.xml.";
        }
        if (!Arrays.asList(VALID_OS).contains(os)) {
            return "The value of <os> is not correct, supported values are: windows, linux and docker.";
        }
        return null;
    }

    @Override
    public String validateRuntimeStack() {
        MavenRuntimeConfig mavenRuntimeConfig = this.mojo.getRuntime();
        if (mavenRuntimeConfig == null || mavenRuntimeConfig.isEmpty()) {
            return null;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)mavenRuntimeConfig.getOs(), (CharSequence)OperatingSystem.LINUX.getValue())) {
            return null;
        }
        JavaVersion javaVersion = JavaVersion.fromString((String)mavenRuntimeConfig.getJavaVersionRaw());
        WebContainer webContainer = WebContainer.fromString((String)mavenRuntimeConfig.getWebContainerRaw());
        Runtime result = Runtime.values().stream().filter(runtime -> runtime.getOperatingSystem() == OperatingSystem.LINUX).filter(runtime -> runtime.getJavaVersion() == javaVersion && runtime.getWebContainer() == webContainer).findAny().orElse(null);
        return result == null ? String.format("Unsupported value \"%s - %s\" for linux runtime, please refer %s more information", mavenRuntimeConfig.getWebContainerRaw(), mavenRuntimeConfig.getJavaVersionRaw(), "https://aka.ms/maven_webapp_runtime") : null;
    }

    @Override
    public String validateJavaVersion() {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return "Please config the <runtime> in pom.xml.";
        }
        String javaVersionRaw = runtime.getJavaVersionRaw();
        if (JavaVersion.fromString((String)javaVersionRaw) == null) {
            return String.format("Unsupported value %s for <javaVersion> in pom.xml, please refer %s.", runtime.getJavaVersionRaw(), "https://aka.ms/maven_webapp_runtime");
        }
        return null;
    }

    @Override
    public String validateWebContainer() {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return "Please config the <runtime> in pom.xml.";
        }
        if (WebContainer.fromString((String)runtime.getWebContainerRaw()) == null) {
            return String.format("Unsupported value %s for <webContainer> in pom.xml, please refer %s.", runtime.getWebContainerRaw(), "https://aka.ms/maven_webapp_runtime");
        }
        return null;
    }

    @Override
    public String validateImage() {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return "Please configure the <runtime> in pom.xml.";
        }
        if (StringUtils.isEmpty((CharSequence)runtime.getImage())) {
            return "Please config the <image> of <runtime> in pom.xml.";
        }
        return null;
    }
}

