/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.configuration;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class RuntimeSetting {
    protected String os;
    protected String javaVersion;
    protected String webContainer;
    protected String image;
    protected String serverId;
    protected String registryUrl;
    public static final String RUNTIME_CONFIG_REFERENCE = "https://aka.ms/maven_webapp_runtime";

    public String getOs() {
        return this.os;
    }

    public OperatingSystemEnum getOsEnum() {
        try {
            return OperatingSystemEnum.fromString(this.os);
        }
        catch (MojoExecutionException e) {
            return null;
        }
    }

    public JavaVersion getJavaVersion() {
        return StringUtils.isEmpty((CharSequence)this.javaVersion) || !this.checkJavaVersion(this.javaVersion) ? null : JavaVersion.fromString((String)this.javaVersion);
    }

    public RuntimeStack getLinuxRuntime() {
        return RuntimeStackUtils.getRuntimeStack(this.javaVersion, this.webContainer);
    }

    public WebContainer getWebContainer() {
        if (!this.checkWebContainer(this.webContainer)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.webContainer)) {
            return WebContainer.TOMCAT_8_5_NEWEST;
        }
        return WebContainer.fromString((String)this.webContainer);
    }

    public String getImage() {
        return this.image;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.os) && StringUtils.isEmpty((CharSequence)this.javaVersion) && StringUtils.isEmpty((CharSequence)this.webContainer) && StringUtils.isEmpty((CharSequence)this.image) && StringUtils.isEmpty((CharSequence)this.serverId) && StringUtils.isEmpty((CharSequence)this.registryUrl);
    }

    protected boolean checkJavaVersion(String value) {
        for (JavaVersion version : JavaVersion.values()) {
            if (!version.toString().equals(value)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkWebContainer(String value) {
        for (WebContainer container : WebContainer.values()) {
            if (!container.toString().equals(value)) continue;
            return true;
        }
        return false;
    }

    static {
        WebContainer.fromString((String)"java 11");
    }
}

