/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ConfigurationSourceType;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotSetting;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class DeploymentSlotHandler {
    private static final String INVALID_SLOT_SETTINGS = "No <deploymentSlot> is specified in pom.xml. Please configure it for slot deployment.";
    private static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String INVALID_SLOT_NAME = String.format("Invalid value of <name> inside <deploymentSlot> in pom.xml, it needs to match the pattern '%s'", "[A-Za-z0-9-]{1,60}");
    private static final String EMPTY_CONFIGURATION_SOURCE = "Creating a new deployment slot without any configuration...";
    private static final String DEFAULT_CONFIGURATION_SOURCE = "Creating a new deployment slot and copying configuration from parent...";
    private static final String COPY_CONFIGURATION_FROM_SLOT = "Creating a new deployment slot and copying configuration from slot '%s'...";
    private static final String UNKNOWN_CONFIGURATION_SOURCE = "Unknown <configurationSource> value for creating deployment slot. Please use 'NEW', 'PARENT' or specify an existing slot.";
    private static final String TARGET_CONFIGURATION_SOURCE_SLOT_NOT_EXIST = "The deployment slot specified in <configurationSource> does not exist.";
    private AbstractWebAppMojo mojo;

    public DeploymentSlotHandler(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    public void createDeploymentSlotIfNotExist() throws MojoExecutionException, AzureAuthFailureException {
        DeploymentSlotSetting slotSetting = this.mojo.getDeploymentSlotSetting();
        this.assureValidSlotSetting(slotSetting);
        WebApp app = this.mojo.getWebApp();
        String slotName = slotSetting.getName();
        if (this.mojo.getDeploymentSlot(app, slotName) == null) {
            this.createDeploymentSlot(app, slotName, slotSetting.getConfigurationSource());
        }
    }

    protected void createDeploymentSlot(WebApp app, String slotName, String configurationSource) throws MojoExecutionException {
        this.assureValidSlotName(slotName);
        DeploymentSlot.DefinitionStages.Blank definedSlot = (DeploymentSlot.DefinitionStages.Blank)app.deploymentSlots().define(slotName);
        ConfigurationSourceType type = ConfigurationSourceType.fromString(configurationSource);
        switch (type) {
            case NEW: {
                this.mojo.getLog().info((CharSequence)EMPTY_CONFIGURATION_SOURCE);
                definedSlot.withBrandNewConfiguration().create();
                break;
            }
            case PARENT: {
                this.mojo.getLog().info((CharSequence)DEFAULT_CONFIGURATION_SOURCE);
                definedSlot.withConfigurationFromParent().create();
                break;
            }
            case OTHERS: {
                DeploymentSlot configurationSourceSlot = this.mojo.getDeploymentSlot(app, configurationSource);
                if (configurationSourceSlot == null) {
                    throw new MojoExecutionException(TARGET_CONFIGURATION_SOURCE_SLOT_NOT_EXIST);
                }
                this.mojo.getLog().info((CharSequence)String.format(COPY_CONFIGURATION_FROM_SLOT, configurationSource));
                definedSlot.withConfigurationFromDeploymentSlot(configurationSourceSlot).create();
                break;
            }
            default: {
                throw new MojoExecutionException(UNKNOWN_CONFIGURATION_SOURCE);
            }
        }
    }

    protected void assureValidSlotSetting(DeploymentSlotSetting slotSetting) throws MojoExecutionException {
        if (slotSetting == null) {
            throw new MojoExecutionException(INVALID_SLOT_SETTINGS);
        }
    }

    protected void assureValidSlotName(String slotName) throws MojoExecutionException {
        Pattern pattern = Pattern.compile(SLOT_NAME_PATTERN, 2);
        if (StringUtils.isEmpty((String)slotName) || !pattern.matcher(slotName).matches()) {
            throw new MojoExecutionException(INVALID_SLOT_NAME);
        }
    }
}

