/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandler;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.artifacthandler.FTPArtifactHandlerImpl;
import com.microsoft.azure.maven.artifacthandler.ZIPArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.DockerImageType;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.handlers.DeploymentSlotHandler;
import com.microsoft.azure.maven.webapp.handlers.HandlerFactory;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.ArtifactHandlerImplV2;
import com.microsoft.azure.maven.webapp.handlers.artifact.JarArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.NONEArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.WarArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.maven.webapp.handlers.runtime.LinuxRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.NullRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.PrivateDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.PrivateRegistryRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.PublicDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.WindowsRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class HandlerFactoryImpl
extends HandlerFactory {
    public static final String UNKNOWN_DEPLOYMENT_TYPE = "The value of <deploymentType> is unknown, supported values are: jar, war, zip, ftp, auto and none.";

    @Override
    public RuntimeHandler getRuntimeHandler(WebAppConfiguration config, Azure azureClient, Log log) throws MojoExecutionException {
        BaseRuntimeHandler.Builder builder;
        if (config.getOs() == null) {
            return new NullRuntimeHandlerImpl();
        }
        switch (config.getOs()) {
            case Windows: {
                builder = ((WindowsRuntimeHandlerImpl.Builder)new WindowsRuntimeHandlerImpl.Builder().javaVersion(config.getJavaVersion())).webContainer(config.getWebContainer());
                break;
            }
            case Linux: {
                builder = new LinuxRuntimeHandlerImpl.Builder().runtime(config.getRuntimeStack());
                break;
            }
            case Docker: {
                builder = this.getDockerRuntimeHandlerBuilder(config);
                break;
            }
            default: {
                throw new MojoExecutionException("Unknown ");
            }
        }
        return ((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)builder.appName(config.getAppName())).resourceGroup(config.getResourceGroup())).region(config.getRegion())).pricingTier(config.getPricingTier())).servicePlanName(config.getServicePlanName())).servicePlanResourceGroup(config.getServicePlanResourceGroup())).azure(azureClient)).log(log)).build();
    }

    protected BaseRuntimeHandler.Builder getDockerRuntimeHandlerBuilder(WebAppConfiguration config) throws MojoExecutionException {
        PublicDockerHubRuntimeHandlerImpl.Builder builder;
        DockerImageType imageType = WebAppUtils.getDockerImageType(config.getImage(), config.getServerId(), config.getRegistryUrl());
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                builder = new PublicDockerHubRuntimeHandlerImpl.Builder();
                break;
            }
            case PRIVATE_DOCKER_HUB: {
                builder = new PrivateDockerHubRuntimeHandlerImpl.Builder().mavenSettings(config.getMavenSettings());
                break;
            }
            case PRIVATE_REGISTRY: {
                builder = new PrivateRegistryRuntimeHandlerImpl.Builder().mavenSettings(config.getMavenSettings());
                break;
            }
            default: {
                throw new MojoExecutionException("Invalid docker runtime configured.");
            }
        }
        return ((BaseRuntimeHandler.Builder)((BaseRuntimeHandler.Builder)builder.image(config.getImage())).serverId(config.getServerId())).registryUrl(config.getRegistryUrl());
    }

    @Override
    public SettingsHandler getSettingsHandler(AbstractWebAppMojo mojo) {
        return new SettingsHandlerImpl(mojo);
    }

    @Override
    public ArtifactHandler getArtifactHandler(AbstractWebAppMojo mojo) throws MojoExecutionException {
        switch (SchemaVersion.fromString(mojo.getSchemaVersion())) {
            case V1: {
                return this.getV1ArtifactHandler(mojo);
            }
            case V2: {
                return this.getV2ArtifactHandler(mojo);
            }
        }
        throw new MojoExecutionException("Unknown value of <schemaVersion> in pom.xml.");
    }

    protected ArtifactHandler getV1ArtifactHandler(AbstractWebAppMojo mojo) throws MojoExecutionException {
        Object builder;
        switch (mojo.getDeploymentType()) {
            case FTP: {
                builder = new FTPArtifactHandlerImpl.Builder();
                break;
            }
            case ZIP: {
                builder = new ZIPArtifactHandlerImpl.Builder();
                break;
            }
            case JAR: {
                builder = new JarArtifactHandlerImpl.Builder().jarFile(mojo.getJarFile()).linuxRuntime(mojo.getLinuxRuntime());
                break;
            }
            case WAR: {
                builder = new WarArtifactHandlerImpl.Builder().warFile(mojo.getWarFile()).contextPath(mojo.getPath());
                break;
            }
            case NONE: {
                builder = new NONEArtifactHandlerImpl.Builder();
                break;
            }
            case EMPTY: 
            case AUTO: {
                builder = this.getArtifactHandlerBuilderFromPackaging(mojo);
                break;
            }
            default: {
                throw new MojoExecutionException("The value of <deploymentType> is unknown.");
            }
        }
        return builder.project(mojo.getProject()).session(mojo.getSession()).filtering(mojo.getMavenResourcesFiltering()).resources(mojo.getResources()).stagingDirectoryPath(mojo.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(mojo.getBuildDirectoryAbsolutePath()).log(mojo.getLog()).build();
    }

    protected ArtifactHandler getV2ArtifactHandler(AbstractWebAppMojo mojo) {
        return ((ArtifactHandlerImplV2.Builder)((ArtifactHandlerImplV2.Builder)((ArtifactHandlerImplV2.Builder)((ArtifactHandlerImplV2.Builder)((ArtifactHandlerImplV2.Builder)((ArtifactHandlerImplV2.Builder)new ArtifactHandlerImplV2.Builder().project(mojo.getProject())).session(mojo.getSession())).filtering(mojo.getMavenResourcesFiltering())).resources(mojo.getDeployment().getResources())).stagingDirectoryPath(mojo.getDeploymentStagingDirectoryPath())).log(mojo.getLog())).runtime(mojo.getRuntime()).build();
    }

    protected ArtifactHandlerBase.Builder getArtifactHandlerBuilderFromPackaging(AbstractWebAppMojo mojo) throws MojoExecutionException {
        String packaging = mojo.getProject().getPackaging();
        if (StringUtils.isEmpty((String)packaging)) {
            throw new MojoExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
        }
        switch (packaging = packaging.toLowerCase(Locale.ENGLISH).trim()) {
            case "war": {
                return new WarArtifactHandlerImpl.Builder().warFile(mojo.getWarFile()).contextPath(mojo.getPath());
            }
            case "jar": {
                return new JarArtifactHandlerImpl.Builder().jarFile(mojo.getJarFile()).linuxRuntime(mojo.getLinuxRuntime());
            }
        }
        throw new MojoExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
    }

    @Override
    public DeploymentSlotHandler getDeploymentSlotHandler(AbstractWebAppMojo mojo) {
        return new DeploymentSlotHandler(mojo);
    }
}

