/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public class PublicDockerHubRuntimeHandlerImpl
extends BaseRuntimeHandler {
    private PublicDockerHubRuntimeHandlerImpl(Builder builder) {
        super(builder);
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws Exception {
        AppServicePlan plan = this.createOrGetAppServicePlan();
        return WebAppUtils.defineLinuxApp(this.resourceGroup, this.appName, this.azure, plan).withPublicDockerHubImage(this.image);
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws Exception {
        WebAppUtils.assureLinuxWebApp(app);
        WebAppUtils.clearTags(app);
        return ((WebApp.Update)app.update()).withPublicDockerHubImage(this.image);
    }

    @Override
    protected OperatingSystem getAppServicePlatform() {
        return OperatingSystem.LINUX;
    }

    public static class Builder
    extends BaseRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PublicDockerHubRuntimeHandlerImpl build() {
            return new PublicDockerHubRuntimeHandlerImpl(this);
        }
    }
}

