/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.utils.AppServiceUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotSetting;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class ConfigurationParser {
    protected final AbstractWebAppMojo mojo;
    protected final AbstractConfigurationValidator validator;

    protected ConfigurationParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        this.mojo = mojo;
        this.validator = validator;
    }

    protected String getAppName() throws MojoExecutionException {
        this.validate(this.validator.validateAppName());
        return this.mojo.getAppName();
    }

    protected String getResourceGroup() throws MojoExecutionException {
        this.validate(this.validator.validateResourceGroup());
        return this.mojo.getResourceGroup();
    }

    protected PricingTier getPricingTier() throws MojoExecutionException {
        this.validate(this.validator.validatePricingTier());
        PricingTier pricingTier = AppServiceUtils.getPricingTierFromString((String)this.mojo.getPricingTier());
        return pricingTier == null ? WebAppConfiguration.DEFAULT_PRICINGTIER : pricingTier;
    }

    protected DeploymentSlotSetting getDeploymentSlotSetting() throws MojoExecutionException {
        this.validate(this.validator.validateDeploymentSlot());
        return this.mojo.getDeploymentSlotSetting();
    }

    protected abstract OperatingSystemEnum getOs() throws MojoExecutionException;

    protected abstract Region getRegion() throws MojoExecutionException;

    protected abstract RuntimeStack getRuntimeStack() throws MojoExecutionException;

    protected abstract String getImage() throws MojoExecutionException;

    protected abstract String getServerId() throws MojoExecutionException;

    protected abstract String getRegistryUrl();

    protected abstract String getSchemaVersion();

    protected abstract JavaVersion getJavaVersion() throws MojoExecutionException;

    protected abstract WebContainer getWebContainer() throws MojoExecutionException;

    protected abstract List<Resource> getResources() throws MojoExecutionException;

    protected void validate(String errorMessage) throws MojoExecutionException {
        if (errorMessage != null) {
            throw new MojoExecutionException(errorMessage);
        }
    }

    public WebAppConfiguration getWebAppConfiguration() throws MojoExecutionException {
        WebAppConfiguration.Builder builder = new WebAppConfiguration.Builder();
        OperatingSystemEnum os = this.getOs();
        if (os == null) {
            this.mojo.getLog().debug((CharSequence)"No runtime related config is specified. It will cause error if creating a new web app.");
        } else {
            switch (os) {
                case Windows: {
                    builder = builder.javaVersion(this.getJavaVersion()).webContainer(this.getWebContainer());
                    break;
                }
                case Linux: {
                    builder = builder.runtimeStack(this.getRuntimeStack());
                    break;
                }
                case Docker: {
                    builder = builder.image(this.getImage()).serverId(this.getServerId()).registryUrl(this.getRegistryUrl());
                    break;
                }
                default: {
                    throw new MojoExecutionException("Invalid operating system from the configuration.");
                }
            }
        }
        return builder.appName(this.getAppName()).resourceGroup(this.getResourceGroup()).region(this.getRegion()).pricingTier(this.getPricingTier()).servicePlanName(this.mojo.getAppServicePlanName()).servicePlanResourceGroup(this.mojo.getAppServicePlanResourceGroup()).deploymentSlotSetting(this.getDeploymentSlotSetting()).os(os).mavenSettings(this.mojo.getSettings()).resources(this.getResources()).stagingDirectoryPath(this.mojo.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.mojo.getBuildDirectoryAbsolutePath()).project(this.mojo.getProject()).session(this.mojo.getSession()).filtering(this.mojo.getMavenResourcesFiltering()).schemaVersion(this.getSchemaVersion()).build();
    }
}

