/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.validator;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.RuntimeSetting;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import java.util.Arrays;
import org.codehaus.plexus.util.StringUtils;

public class V2ConfigurationValidator
extends AbstractConfigurationValidator {
    public static final String[] VALID_OS = new String[]{"windows", "linux", "docker"};

    public V2ConfigurationValidator(AbstractWebAppMojo mojo) {
        super(mojo);
    }

    @Override
    public String validateRegion() {
        String region = this.mojo.getRegion();
        if (!StringUtils.isEmpty((String)region) && Region.findByLabelOrName((String)region) == null) {
            return "The value of <region> is not supported, please correct it in pom.xml.";
        }
        return null;
    }

    @Override
    public String validateOs() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        String os = runtime.getOs();
        if (runtime.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((String)os)) {
            return "Pleas configure the <os> of <runtime> in pom.xml.";
        }
        if (!Arrays.asList(VALID_OS).contains(os)) {
            return "The value of <os> is not correct, supported values are: windows, linux and docker.";
        }
        return null;
    }

    @Override
    public String validateRuntimeStack() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null || runtime.isEmpty()) {
            return null;
        }
        RuntimeStack result = runtime.getLinuxRuntime();
        return result == null ? String.format("Unsupported values for linux runtime, please refer %s more information", "https://aka.ms/maven_webapp_runtime") : null;
    }

    @Override
    public String validateJavaVersion() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return "Pleas config the <runtime> in pom.xml.";
        }
        if (runtime.getJavaVersion() == null || !JavaVersion.values().contains(runtime.getJavaVersion())) {
            return "The configuration <javaVersion> in pom.xml is not correct.";
        }
        return null;
    }

    @Override
    public String validateWebContainer() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return "Pleas config the <runtime> in pom.xml.";
        }
        if (runtime.getWebContainer() == null) {
            return "The configuration <webContainer> in pom.xml is not correct.";
        }
        return null;
    }

    @Override
    public String validateImage() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return "Please configure the <runtime> in pom.xml.";
        }
        if (StringUtils.isEmpty((String)runtime.getImage())) {
            return "Please config the <image> of <runtime> in pom.xml.";
        }
        return null;
    }
}

