/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.handlers.RuntimeHandler;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.deploytarget.DeploymentSlotDeployTarget;
import com.microsoft.azure.maven.webapp.deploytarget.WebAppDeployTarget;
import com.microsoft.azure.maven.webapp.handlers.HandlerFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    public static final String WEBAPP_NOT_EXIST = "Target Web App doesn't exist. Creating a new one...";
    public static final String WEBAPP_CREATED = "Successfully created Web App.";
    public static final String CREATE_DEPLOYMENT_SLOT = "Target Deployment Slot doesn't exist. Creating a new one...";
    public static final String CREATE_DEPLOYMENT_SLOT_DONE = "Successfully created the Deployment Slot.";
    public static final String UPDATE_WEBAPP = "Updating target Web App...";
    public static final String UPDATE_WEBAPP_SKIP = "No runtime configured. Skip the update.";
    public static final String UPDATE_WEBAPP_DONE = "Successfully updated Web App.";
    public static final String STOP_APP = "Stopping Web App before deploying artifacts...";
    public static final String START_APP = "Starting Web App after deploying artifacts...";
    public static final String STOP_APP_DONE = "Successfully stopped Web App.";
    public static final String START_APP_DONE = "Successfully started Web App.";
    public static final String WEBAPP_NOT_EXIST_FOR_SLOT = "The Web App specified in pom.xml does not exist. Please make sure the Web App name is correct.";
    public static final String SLOT_SHOULD_EXIST_NOW = "Target deployment slot still does not exist. Please check if any error message during creation.";
    protected DeploymentUtil util = new DeploymentUtil();

    protected void doExecute() throws AzureExecutionException {
        try {
            RuntimeHandler runtimeHandler = this.getFactory().getRuntimeHandler(this.getWebAppConfiguration(), this.getAzureClient());
            WebApp app = this.getWebApp();
            if (app == null) {
                if (this.isDeployToDeploymentSlot()) {
                    throw new AzureExecutionException(WEBAPP_NOT_EXIST_FOR_SLOT);
                }
                this.createWebApp(runtimeHandler);
            } else {
                this.updateWebApp(runtimeHandler, app);
            }
            this.deployArtifacts();
        }
        catch (AzureAuthFailureException | IOException | InterruptedException e) {
            throw new AzureExecutionException(String.format("Encoutering error when deploying to azure: '%s'", e.getMessage()), e);
        }
    }

    protected void createWebApp(RuntimeHandler runtimeHandler) throws AzureExecutionException {
        Log.info((String)WEBAPP_NOT_EXIST);
        WebApp.DefinitionStages.WithCreate withCreate = (WebApp.DefinitionStages.WithCreate)runtimeHandler.defineAppWithRuntime();
        this.getFactory().getSettingsHandler(this).processSettings(withCreate);
        withCreate.create();
        Log.info((String)WEBAPP_CREATED);
    }

    protected void updateWebApp(RuntimeHandler runtimeHandler, WebApp app) throws AzureExecutionException, AzureAuthFailureException {
        runtimeHandler.updateAppServicePlan((WebAppBase)app);
        WebApp.Update update = (WebApp.Update)runtimeHandler.updateAppRuntime((WebAppBase)app);
        if (update == null) {
            Log.info((String)UPDATE_WEBAPP_SKIP);
        } else {
            Log.info((String)UPDATE_WEBAPP);
            this.getFactory().getSettingsHandler(this).processSettings(update);
            update.apply();
            Log.info((String)UPDATE_WEBAPP_DONE);
        }
        if (this.isDeployToDeploymentSlot()) {
            Log.info((String)CREATE_DEPLOYMENT_SLOT);
            this.getFactory().getDeploymentSlotHandler(this).createDeploymentSlotIfNotExist();
            Log.info((String)CREATE_DEPLOYMENT_SLOT_DONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployArtifacts() throws AzureAuthFailureException, InterruptedException, AzureExecutionException, IOException {
        try {
            DeployTarget target;
            this.util.beforeDeployArtifacts();
            WebApp app = this.getWebApp();
            if (this.isDeployToDeploymentSlot()) {
                String slotName = this.getDeploymentSlotSetting().getName();
                DeploymentSlot slot = this.getDeploymentSlot(app, slotName);
                if (slot == null) {
                    throw new AzureExecutionException(SLOT_SHOULD_EXIST_NOW);
                }
                target = new DeploymentSlotDeployTarget(slot);
            } else {
                target = new WebAppDeployTarget(app);
            }
            this.getFactory().getArtifactHandler(this).publish(target);
        }
        finally {
            this.util.afterDeployArtifacts();
        }
    }

    protected HandlerFactory getFactory() {
        return HandlerFactory.getInstance();
    }

    class DeploymentUtil {
        boolean isAppStopped = false;

        DeploymentUtil() {
        }

        public void beforeDeployArtifacts() throws AzureAuthFailureException, InterruptedException {
            if (DeployMojo.this.isStopAppDuringDeployment()) {
                Log.info((String)DeployMojo.STOP_APP);
                DeployMojo.this.getWebApp().stop();
                TimeUnit.SECONDS.sleep(10L);
                this.isAppStopped = true;
                Log.info((String)DeployMojo.STOP_APP_DONE);
            }
        }

        public void afterDeployArtifacts() throws AzureAuthFailureException, IOException {
            if (this.isAppStopped) {
                Log.info((String)DeployMojo.START_APP);
                DeployMojo.this.getWebApp().start();
                this.isAppStopped = false;
                Log.info((String)DeployMojo.START_APP_DONE);
            }
            if (DeployMojo.this.stagingDirectory != null) {
                FileUtils.forceDeleteOnExit((File)DeployMojo.this.stagingDirectory);
            }
        }
    }
}

