/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.google.common.io.Files;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.webapp.deploytarget.DeploymentSlotDeployTarget;
import com.microsoft.azure.maven.webapp.deploytarget.WebAppDeployTarget;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ArtifactHandlerUtils {
    public static final String DEFAULT_APP_SERVICE_JAR_NAME = "app.jar";

    public static Runnable getRealWarDeployExecutor(final DeployTarget target, final File war, final String path) throws AzureExecutionException {
        if (target instanceof WebAppDeployTarget) {
            return new Runnable(){

                @Override
                public void run() {
                    ((WebAppDeployTarget)target).warDeploy(war, path);
                }
            };
        }
        if (target instanceof DeploymentSlotDeployTarget) {
            return new Runnable(){

                @Override
                public void run() {
                    ((DeploymentSlotDeployTarget)target).warDeploy(war, path);
                }
            };
        }
        throw new AzureExecutionException("The type of deploy target is unknown, supported types are WebApp and DeploymentSlot.");
    }

    public static boolean performActionWithRetry(Runnable runnable, int maxRetryTimes) {
        for (int retryCount = 0; retryCount < maxRetryTimes; ++retryCount) {
            try {
                runnable.run();
                return true;
            }
            catch (Exception e) {
                Log.info((String)String.format("Exception occurred during deployment: %s, retry immediately(%d/%d)...", e.getMessage(), retryCount, maxRetryTimes));
                continue;
            }
        }
        return false;
    }

    public static String getContextPathFromFileName(String stagingDirectoryPath, String filePath) throws AzureExecutionException {
        if (StringUtils.isEmpty((CharSequence)stagingDirectoryPath)) {
            throw new AzureExecutionException("Can not get the context path because the staging directory path is null or empty. .");
        }
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new AzureExecutionException("Can not get the context path because the file path is null or empty");
        }
        return Paths.get(stagingDirectoryPath, new String[0]).relativize(Paths.get(filePath, new String[0]).getParent()).toString();
    }

    public static List<File> getArtifacts(File directory) {
        File[] files = directory.listFiles();
        return Arrays.stream(files).filter(File::isFile).collect(Collectors.toList());
    }

    public static boolean areAllWarFiles(List<File> allArtifacts) {
        for (File artifacts : allArtifacts) {
            if ("war".equalsIgnoreCase(Files.getFileExtension((String)artifacts.getName()))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasWarFiles(List<File> allArtifacts) {
        for (File artifacts : allArtifacts) {
            if (!"war".equalsIgnoreCase(Files.getFileExtension((String)artifacts.getName()))) continue;
            return true;
        }
        return false;
    }
}

