/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public abstract class WebAppRuntimeHandler
extends BaseRuntimeHandler<WebApp> {
    protected RuntimeStack runtime;
    protected JavaVersion javaVersion;
    protected WebContainer webContainer;

    protected WebAppRuntimeHandler(Builder<?> builder) {
        super(builder);
        this.runtime = builder.runtime;
        this.javaVersion = builder.javaVersion;
        this.webContainer = builder.webContainer;
    }

    public abstract WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException;

    public abstract WebApp.Update updateAppRuntime(WebApp var1) throws AzureExecutionException;

    protected abstract OperatingSystem getAppServicePlatform();

    protected void changeAppServicePlan(WebApp app, AppServicePlan appServicePlan) {
        ((WebApp.Update)app.update()).withExistingAppServicePlan(appServicePlan).apply();
    }

    protected AppServicePlan createOrGetAppServicePlan() throws AzureExecutionException {
        return WebAppUtils.createOrGetAppServicePlan(this.servicePlanName, this.resourceGroup, this.azure, this.servicePlanResourceGroup, this.region, this.getPricingTierOrDefault(), this.getAppServicePlatform());
    }

    protected PricingTier getPricingTierOrDefault() {
        return this.pricingTier == null ? WebAppConfiguration.DEFAULT_PRICINGTIER : this.pricingTier;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRuntimeHandler.Builder<T> {
        protected RuntimeStack runtime;
        protected JavaVersion javaVersion;
        protected WebContainer webContainer;

        public T runtime(RuntimeStack value) {
            this.runtime = value;
            return (T)this.self();
        }

        public T javaVersion(JavaVersion value) {
            this.javaVersion = value;
            return (T)this.self();
        }

        public T webContainer(WebContainer value) {
            this.webContainer = value;
            return (T)this.self();
        }

        public abstract WebAppRuntimeHandler build();

        protected abstract T self();
    }
}

