/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.handlers.runtime.WebAppRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public class WindowsRuntimeHandlerImpl
extends WebAppRuntimeHandler {
    private WindowsRuntimeHandlerImpl(Builder builder) {
        super(builder);
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException {
        AppServicePlan plan = this.createOrGetAppServicePlan();
        WebApp.DefinitionStages.WithCreate withCreate = WebAppUtils.defineWindowsApp(this.resourceGroup, this.appName, this.azure, plan);
        withCreate.withJavaVersion(this.javaVersion).withWebContainer(this.webContainer);
        return withCreate;
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws AzureExecutionException {
        WebAppUtils.assureWindowsWebApp(app);
        WebAppUtils.clearTags(app);
        WebApp.Update update = (WebApp.Update)app.update();
        update.withJavaVersion(this.javaVersion).withWebContainer(this.webContainer);
        return update;
    }

    @Override
    protected OperatingSystem getAppServicePlatform() {
        return OperatingSystem.WINDOWS;
    }

    public static class Builder
    extends WebAppRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WindowsRuntimeHandlerImpl build() {
            return new WindowsRuntimeHandlerImpl(this);
        }
    }
}

