/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.appservice.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.RuntimeSetting;
import com.microsoft.azure.maven.webapp.parser.ConfigurationParser;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Resource;

public class V2ConfigurationParser
extends ConfigurationParser {
    public V2ConfigurationParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        super(mojo, validator);
    }

    @Override
    protected OperatingSystemEnum getOs() throws AzureExecutionException {
        this.validate(this.validator.validateOs());
        RuntimeSetting runtime = this.mojo.getRuntime();
        String os = runtime.getOs();
        if (runtime.isEmpty()) {
            return null;
        }
        switch (os.toLowerCase(Locale.ENGLISH)) {
            case "windows": {
                return OperatingSystemEnum.Windows;
            }
            case "linux": {
                return OperatingSystemEnum.Linux;
            }
            case "docker": {
                return OperatingSystemEnum.Docker;
            }
        }
        return null;
    }

    @Override
    protected Region getRegion() throws AzureExecutionException {
        this.validate(this.validator.validateRegion());
        String region = this.mojo.getRegion();
        return Region.fromName((String)region);
    }

    @Override
    protected RuntimeStack getRuntimeStack() throws AzureExecutionException {
        this.validate(this.validator.validateRuntimeStack());
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null || runtime.isEmpty()) {
            return null;
        }
        return runtime.getLinuxRuntime();
    }

    @Override
    protected String getImage() throws AzureExecutionException {
        this.validate(this.validator.validateImage());
        RuntimeSetting runtime = this.mojo.getRuntime();
        return runtime.getImage();
    }

    @Override
    protected String getServerId() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return null;
        }
        return runtime.getServerId();
    }

    @Override
    protected String getRegistryUrl() {
        RuntimeSetting runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return null;
        }
        return runtime.getRegistryUrl();
    }

    @Override
    protected String getSchemaVersion() {
        return "V2";
    }

    @Override
    protected WebContainer getWebContainer() throws AzureExecutionException {
        this.validate(this.validator.validateWebContainer());
        RuntimeSetting runtime = this.mojo.getRuntime();
        return runtime.getWebContainer();
    }

    @Override
    protected JavaVersion getJavaVersion() throws AzureExecutionException {
        this.validate(this.validator.validateJavaVersion());
        RuntimeSetting runtime = this.mojo.getRuntime();
        return runtime.getJavaVersion();
    }

    @Override
    protected List<Resource> getResources() {
        Deployment deployment = this.mojo.getDeployment();
        return deployment == null ? null : deployment.getResources();
    }
}

