/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Resource;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public class Utils {
    private static final String CREATE_TEMP_FILE_FAIL = "Failed to create temp file %s.%s";

    public static File createTempFile(String prefix, String suffix) throws AzureExecutionException {
        try {
            File zipFile = File.createTempFile(prefix, suffix);
            zipFile.deleteOnExit();
            return zipFile;
        }
        catch (IOException e) {
            throw new AzureExecutionException(String.format(CREATE_TEMP_FILE_FAIL, prefix, suffix), e.getCause());
        }
    }

    public static List<File> getArtifacts(Resource resource) {
        ArrayList<File> result = new ArrayList<File>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            directoryScanner.setBasedir(resource.getDirectory());
            directoryScanner.setIncludes(resource.getIncludes().toArray(new String[0]));
            String[] exclude = resource.getExcludes() == null ? new String[]{} : resource.getExcludes().toArray(new String[0]);
            directoryScanner.setExcludes(exclude);
            directoryScanner.scan();
            List resourceFiles = Arrays.stream(directoryScanner.getIncludedFiles()).map(path -> new File(resource.getDirectory(), (String)path)).collect(Collectors.toList());
            result.addAll(resourceFiles);
        }
        return result;
    }

    private Utils() {
    }
}

