/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.utils.AppServiceUtils;

public class WebAppUtils {
    public static final String SERVICE_PLAN_NOT_APPLICABLE = "The App Service Plan '%s' is not a %s Plan";
    public static final String CREATE_SERVICE_PLAN = "Creating App Service Plan '%s'...";
    public static final String SERVICE_PLAN_CREATED = "Successfully created App Service Plan.";
    public static final String CONFIGURATION_NOT_APPLICABLE = "The configuration is not applicable for the target Web App (%s). Please correct it in pom.xml.";

    public static void assureLinuxWebApp(WebApp app) throws AzureExecutionException {
        if (!WebAppUtils.isLinuxWebApp(app)) {
            throw new AzureExecutionException(String.format(CONFIGURATION_NOT_APPLICABLE, "Windows"));
        }
    }

    public static void assureWindowsWebApp(WebApp app) throws AzureExecutionException {
        if (WebAppUtils.isLinuxWebApp(app)) {
            throw new AzureExecutionException(String.format(CONFIGURATION_NOT_APPLICABLE, "Linux"));
        }
    }

    public static WebApp.DefinitionStages.WithDockerContainerImage defineLinuxApp(String resourceGroup, String appName, Azure azureClient, AppServicePlan plan) throws AzureExecutionException {
        WebAppUtils.assureLinuxPlan(plan);
        WebApp.DefinitionStages.ExistingLinuxPlanWithGroup existingLinuxPlanWithGroup = ((WebApp.DefinitionStages.Blank)azureClient.webApps().define(appName)).withExistingLinuxPlan(plan);
        return azureClient.resourceGroups().contain(resourceGroup) ? existingLinuxPlanWithGroup.withExistingResourceGroup(resourceGroup) : existingLinuxPlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    public static WebApp.DefinitionStages.WithCreate defineWindowsApp(String resourceGroup, String appName, Azure azureClient, AppServicePlan plan) throws AzureExecutionException {
        WebAppUtils.assureWindowsPlan(plan);
        WebApp.DefinitionStages.ExistingWindowsPlanWithGroup existingWindowsPlanWithGroup = ((WebApp.DefinitionStages.Blank)azureClient.webApps().define(appName)).withExistingWindowsPlan(plan);
        return azureClient.resourceGroups().contain(resourceGroup) ? existingWindowsPlanWithGroup.withExistingResourceGroup(resourceGroup) : existingWindowsPlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    public static AppServicePlan createOrGetAppServicePlan(String servicePlanName, String resourceGroup, Azure azure, String servicePlanResourceGroup, Region region, PricingTier pricingTier, OperatingSystem os) throws AzureExecutionException {
        AppServicePlan plan = AppServiceUtils.getAppServicePlan((String)servicePlanName, (Azure)azure, (String)resourceGroup, (String)servicePlanResourceGroup);
        return plan != null ? plan : WebAppUtils.createAppServicePlan(servicePlanName, resourceGroup, azure, servicePlanResourceGroup, region, pricingTier, os);
    }

    public static AppServicePlan createAppServicePlan(String servicePlanName, String resourceGroup, Azure azure, String servicePlanResourceGroup, Region region, PricingTier pricingTier, OperatingSystem os) throws AzureExecutionException {
        if (region == null) {
            throw new AzureExecutionException("Please config the <region> in pom.xml, it is required to create a new Azure App Service Plan.");
        }
        servicePlanName = AppServiceUtils.getAppServicePlanName((String)servicePlanName);
        String servicePlanResGrp = AppServiceUtils.getAppServicePlanResourceGroup((String)resourceGroup, (String)servicePlanResourceGroup);
        Log.info((String)String.format(CREATE_SERVICE_PLAN, servicePlanName));
        AppServicePlan.DefinitionStages.WithGroup withGroup = (AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)azure.appServices().appServicePlans().define(servicePlanName)).withRegion(region);
        AppServicePlan.DefinitionStages.WithPricingTier withPricingTier = azure.resourceGroups().contain(servicePlanResGrp) ? (AppServicePlan.DefinitionStages.WithPricingTier)withGroup.withExistingResourceGroup(servicePlanResGrp) : (AppServicePlan.DefinitionStages.WithPricingTier)withGroup.withNewResourceGroup(servicePlanResGrp);
        AppServicePlan result = (AppServicePlan)withPricingTier.withPricingTier(pricingTier).withOperatingSystem(os).create();
        Log.info((String)SERVICE_PLAN_CREATED);
        return result;
    }

    public static void clearTags(WebApp app) {
        ((SiteInner)app.inner()).withTags(null);
    }

    private static void assureWindowsPlan(AppServicePlan plan) throws AzureExecutionException {
        if (!plan.operatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
            throw new AzureExecutionException(String.format(SERVICE_PLAN_NOT_APPLICABLE, plan.name(), OperatingSystem.WINDOWS.name()));
        }
    }

    private static void assureLinuxPlan(AppServicePlan plan) throws AzureExecutionException {
        if (!plan.operatingSystem().equals((Object)OperatingSystem.LINUX)) {
            throw new AzureExecutionException(String.format(SERVICE_PLAN_NOT_APPLICABLE, plan.name(), OperatingSystem.LINUX.name()));
        }
    }

    private static boolean isLinuxWebApp(WebApp app) {
        return ((SiteInner)app.inner()).kind().contains("linux");
    }
}

