/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.validator;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class V1ConfigurationValidator
extends AbstractConfigurationValidator {
    private static final String RUNTIME_CONFIG_CONFLICT = "Conflict settings found. <javaVersion>, <linuxRuntime>and <containerSettings> should not be set at the same time.";

    public V1ConfigurationValidator(AbstractWebAppMojo mojo) {
        super(mojo);
    }

    @Override
    public String validateRegion() {
        if (StringUtils.isNotEmpty((CharSequence)this.mojo.getRegion()) && !Arrays.asList(Region.values()).contains(Region.fromName((String)this.mojo.getRegion()))) {
            return "The value of <region> is not correct, please correct it in pom.xml.";
        }
        return null;
    }

    @Override
    public String validateOs() {
        String linuxRuntime = this.mojo.getLinuxRuntime();
        String javaVersion = this.mojo.getJavaVersion();
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        boolean isContainerSettingEmpty = containerSetting == null || containerSetting.isEmpty();
        int osCount = 0;
        if (javaVersion != null) {
            ++osCount;
        }
        if (linuxRuntime != null) {
            ++osCount;
        }
        if (!isContainerSettingEmpty) {
            ++osCount;
        }
        if (osCount > 1) {
            return RUNTIME_CONFIG_CONFLICT;
        }
        return null;
    }

    @Override
    public String validateRuntimeStack() {
        if (this.mojo.getLinuxRuntime() == null) {
            return "Please configure the <linuxRuntime> in pom.xml.";
        }
        return null;
    }

    @Override
    public String validateImage() {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        if (containerSetting == null) {
            return "Please config the <containerSettings> in pom.xml.";
        }
        if (StringUtils.isEmpty((CharSequence)containerSetting.getImageName())) {
            return "Please config the <imageName> of <containerSettings> in pom.xml.";
        }
        return null;
    }

    @Override
    public String validateJavaVersion() {
        String javaVersion = this.mojo.getJavaVersion();
        if (StringUtils.isEmpty((CharSequence)javaVersion)) {
            return "Please config the <javaVersion> in pom.xml.";
        }
        for (JavaVersion version : JavaVersion.values()) {
            if (!version.toString().equals(javaVersion)) continue;
            return null;
        }
        return "The configuration of <javaVersion> in pom.xml is not correct.";
    }

    @Override
    public String validateWebContainer() {
        if (this.mojo.getJavaWebContainer() == null) {
            return "The configuration of <javaWebContainer> in pom.xml is not correct.";
        }
        return null;
    }
}

