/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.handlers.ArtifactHandler;
import com.microsoft.azure.common.handlers.RuntimeHandler;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.deploytarget.DeploymentSlotDeployTarget;
import com.microsoft.azure.maven.webapp.deploytarget.WebAppDeployTarget;
import com.microsoft.azure.maven.webapp.handlers.HandlerFactory;
import com.microsoft.azure.maven.webapp.handlers.artifact.JarArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.NONEArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.WarArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.utils.FTPUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    private static final Path FTP_ROOT = Paths.get("/site/wwwroot", new String[0]);
    private static final String NO_RESOURCES_CONFIG = "<resources> is empty. Please make sure it is configured in pom.xml.";
    public static final String WEBAPP_NOT_EXIST = "Target Web App doesn't exist. Creating a new one...";
    public static final String WEBAPP_CREATED = "Successfully created Web App.";
    public static final String CREATE_DEPLOYMENT_SLOT = "Target Deployment Slot doesn't exist. Creating a new one...";
    public static final String CREATE_DEPLOYMENT_SLOT_DONE = "Successfully created the Deployment Slot.";
    public static final String UPDATE_WEBAPP = "Updating target Web App...";
    public static final String UPDATE_WEBAPP_SKIP = "No runtime configured. Skip the update.";
    public static final String UPDATE_WEBAPP_DONE = "Successfully updated Web App.";
    public static final String STOP_APP = "Stopping Web App before deploying artifacts...";
    public static final String START_APP = "Starting Web App after deploying artifacts...";
    public static final String STOP_APP_DONE = "Successfully stopped Web App.";
    public static final String START_APP_DONE = "Successfully started Web App.";
    public static final String WEBAPP_NOT_EXIST_FOR_SLOT = "The Web App specified in pom.xml does not exist. Please make sure the Web App name is correct.";
    public static final String SLOT_SHOULD_EXIST_NOW = "Target deployment slot still does not exist. Please check if any error message during creation.";
    protected DeploymentUtil util = new DeploymentUtil();

    protected void doExecute() throws AzureExecutionException {
        try {
            RuntimeHandler runtimeHandler = this.getFactory().getRuntimeHandler(this.getWebAppConfiguration(), this.getAzureClient());
            WebApp app = this.getWebApp();
            if (app == null) {
                if (this.isDeployToDeploymentSlot()) {
                    throw new AzureExecutionException(WEBAPP_NOT_EXIST_FOR_SLOT);
                }
                this.createWebApp(runtimeHandler);
            } else {
                this.updateWebApp(runtimeHandler, app);
            }
            this.deployArtifacts(this.getWebAppConfiguration());
        }
        catch (AzureAuthFailureException | IOException | InterruptedException e) {
            throw new AzureExecutionException(String.format("Encoutering error when deploying to azure: '%s'", e.getMessage()), e);
        }
    }

    protected void createWebApp(RuntimeHandler runtimeHandler) throws AzureExecutionException {
        Log.info((String)WEBAPP_NOT_EXIST);
        WebApp.DefinitionStages.WithCreate withCreate = (WebApp.DefinitionStages.WithCreate)runtimeHandler.defineAppWithRuntime();
        this.getFactory().getSettingsHandler(this).processSettings(withCreate);
        withCreate.create();
        Log.info((String)WEBAPP_CREATED);
    }

    protected void updateWebApp(RuntimeHandler runtimeHandler, WebApp app) throws AzureExecutionException, AzureAuthFailureException {
        runtimeHandler.updateAppServicePlan((WebAppBase)app);
        WebApp.Update update = (WebApp.Update)runtimeHandler.updateAppRuntime((WebAppBase)app);
        if (update == null) {
            Log.info((String)UPDATE_WEBAPP_SKIP);
        } else {
            Log.info((String)UPDATE_WEBAPP);
            this.getFactory().getSettingsHandler(this).processSettings(update);
            update.apply();
            Log.info((String)UPDATE_WEBAPP_DONE);
        }
        if (this.isDeployToDeploymentSlot()) {
            Log.info((String)CREATE_DEPLOYMENT_SLOT);
            this.getFactory().getDeploymentSlotHandler(this).createDeploymentSlotIfNotExist();
            Log.info((String)CREATE_DEPLOYMENT_SLOT_DONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployArtifacts(WebAppConfiguration webAppConfiguration) throws AzureAuthFailureException, InterruptedException, AzureExecutionException, IOException {
        try {
            boolean isV1Schema;
            DeployTarget target;
            this.util.beforeDeployArtifacts();
            WebApp app = this.getWebApp();
            if (this.isDeployToDeploymentSlot()) {
                String slotName = this.getDeploymentSlotSetting().getName();
                DeploymentSlot slot = this.getDeploymentSlot(app, slotName);
                if (slot == null) {
                    throw new AzureExecutionException(SLOT_SHOULD_EXIST_NOW);
                }
                target = new DeploymentSlotDeployTarget(slot);
            } else {
                target = new WebAppDeployTarget(app);
            }
            ArtifactHandler artifactHandler = this.getFactory().getArtifactHandler(this);
            boolean bl = isV1Schema = SchemaVersion.fromString(this.getSchemaVersion()) == SchemaVersion.V1;
            if (isV1Schema) {
                this.handleV1Artifact(target, this.resources, artifactHandler);
            } else {
                List<Resource> v2Resources = this.deployment == null ? null : this.deployment.getResources();
                this.handleV2Artifact(target, v2Resources, artifactHandler);
            }
        }
        finally {
            this.util.afterDeployArtifacts();
        }
    }

    private void handleV2Artifact(DeployTarget target, List<Resource> v2Resources, ArtifactHandler artifactHandler) throws IOException, AzureExecutionException {
        if (v2Resources == null || v2Resources.isEmpty()) {
            Log.warn((String)"No <resources> is found in <deployment> element in pom.xml, skip deployment.");
            return;
        }
        Map<Boolean, List<Resource>> resourceMap = v2Resources.stream().collect(Collectors.partitioningBy(DeployMojo::isExternalResource));
        this.deployExternalResources(target, resourceMap.get(true));
        this.copyArtifactsToStagingDirectory(resourceMap.get(false));
        if (resourceMap.get(false).isEmpty()) {
            Log.info((String)"All external resources are already deployed.");
            return;
        }
        artifactHandler.publish(target);
    }

    private void handleV1Artifact(DeployTarget target, List<Resource> v1Resources, ArtifactHandler artifactHandler) throws AzureExecutionException, IOException {
        if (v1Resources == null || v1Resources.isEmpty()) {
            if (!(artifactHandler instanceof NONEArtifactHandlerImpl || artifactHandler instanceof JarArtifactHandlerImpl || artifactHandler instanceof WarArtifactHandlerImpl)) {
                throw new AzureExecutionException(NO_RESOURCES_CONFIG);
            }
        } else {
            this.copyArtifactsToStagingDirectory(v1Resources);
        }
        artifactHandler.publish(target);
    }

    private HandlerFactory getFactory() {
        return HandlerFactory.getInstance();
    }

    private void copyArtifactsToStagingDirectory(List<Resource> resourceList) throws IOException, AzureExecutionException {
        if (resourceList.isEmpty()) {
            return;
        }
        Utils.prepareResources(this.getProject(), this.getSession(), this.getMavenResourcesFiltering(), resourceList, this.getDeploymentStagingDirectoryPath());
    }

    private void deployExternalResources(DeployTarget deployTarget, List<Resource> externalResources) throws AzureExecutionException {
        if (externalResources.isEmpty()) {
            return;
        }
        PublishingProfile publishingProfile = deployTarget.getPublishingProfile();
        String serverUrl = publishingProfile.ftpUrl().split("/", 2)[0];
        try {
            FTPClient ftpClient = FTPUtils.getFTPClient(serverUrl, publishingProfile.ftpUsername(), publishingProfile.ftpPassword());
            for (Resource externalResource : externalResources) {
                this.uploadResource(externalResource, ftpClient);
            }
        }
        catch (IOException e) {
            throw new AzureExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void uploadResource(Resource resource, FTPClient ftpClient) throws IOException {
        List<File> files = Utils.getArtifacts(resource);
        String target = DeployMojo.getAbsoluteTargetPath(resource.getTargetPath());
        for (File file : files) {
            FTPUtils.uploadFile(ftpClient, file.getPath(), target);
        }
    }

    private static String getAbsoluteTargetPath(String targetPath) {
        return StringUtils.startsWith((CharSequence)(targetPath = StringUtils.defaultString((String)targetPath)), (CharSequence)"/") ? targetPath : FTP_ROOT.resolve(Paths.get(targetPath, new String[0])).normalize().toString();
    }

    private static boolean isExternalResource(Resource resource) {
        Path target = Paths.get(DeployMojo.getAbsoluteTargetPath(resource.getTargetPath()), new String[0]);
        return !target.startsWith(FTP_ROOT);
    }

    class DeploymentUtil {
        boolean isAppStopped = false;

        DeploymentUtil() {
        }

        public void beforeDeployArtifacts() throws AzureAuthFailureException, InterruptedException {
            if (DeployMojo.this.isStopAppDuringDeployment()) {
                Log.info((String)DeployMojo.STOP_APP);
                DeployMojo.this.getWebApp().stop();
                TimeUnit.SECONDS.sleep(10L);
                this.isAppStopped = true;
                Log.info((String)DeployMojo.STOP_APP_DONE);
            }
        }

        public void afterDeployArtifacts() throws AzureAuthFailureException, IOException {
            if (this.isAppStopped) {
                Log.info((String)DeployMojo.START_APP);
                DeployMojo.this.getWebApp().start();
                this.isAppStopped = false;
                Log.info((String)DeployMojo.START_APP_DONE);
            }
            if (DeployMojo.this.stagingDirectory != null) {
                FileUtils.forceDeleteOnExit((File)DeployMojo.this.stagingDirectory);
            }
        }
    }
}

