/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.common.appservice.DockerImageType;
import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.handlers.ArtifactHandler;
import com.microsoft.azure.common.handlers.RuntimeHandler;
import com.microsoft.azure.common.handlers.artifact.ArtifactHandlerBase;
import com.microsoft.azure.common.handlers.artifact.FTPArtifactHandlerImpl;
import com.microsoft.azure.common.handlers.artifact.ZIPArtifactHandlerImpl;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.ProjectUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.handlers.DeploymentSlotHandler;
import com.microsoft.azure.maven.webapp.handlers.HandlerFactory;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.ArtifactHandlerImplV2;
import com.microsoft.azure.maven.webapp.handlers.artifact.JarArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.NONEArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.artifact.WarArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.LinuxRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.NullRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.PrivateDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.PrivateRegistryRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.PublicDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.runtime.WebAppRuntimeHandler;
import com.microsoft.azure.maven.webapp.handlers.runtime.WindowsRuntimeHandlerImpl;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public class HandlerFactoryImpl
extends HandlerFactory {
    public static final String UNKNOWN_DEPLOYMENT_TYPE = "The value of <deploymentType> is unknown, supported values are: jar, war, zip, ftp, auto and none.";

    @Override
    public RuntimeHandler getRuntimeHandler(WebAppConfiguration config, Azure azureClient) throws AzureExecutionException {
        WebAppRuntimeHandler.Builder builder;
        if (config.getOs() == null) {
            return new NullRuntimeHandlerImpl();
        }
        switch (config.getOs()) {
            case Windows: {
                builder = ((WindowsRuntimeHandlerImpl.Builder)((Object)new WindowsRuntimeHandlerImpl.Builder().javaVersion(config.getJavaVersion()))).webContainer(config.getWebContainer());
                break;
            }
            case Linux: {
                builder = new LinuxRuntimeHandlerImpl.Builder().runtime(config.getRuntimeStack());
                break;
            }
            case Docker: {
                builder = this.getDockerRuntimeHandlerBuilder(config);
                break;
            }
            default: {
                throw new AzureExecutionException("Unknown ");
            }
        }
        return builder.appName(config.getAppName()).resourceGroup(config.getResourceGroup()).region(config.getRegion()).pricingTier(config.getPricingTier()).servicePlanName(config.getServicePlanName()).servicePlanResourceGroup(config.getServicePlanResourceGroup()).azure(azureClient).build();
    }

    protected WebAppRuntimeHandler.Builder getDockerRuntimeHandlerBuilder(WebAppConfiguration config) throws AzureExecutionException {
        WebAppRuntimeHandler.Builder builder;
        DockerImageType imageType = AppServiceUtils.getDockerImageType((String)config.getImage(), (boolean)StringUtils.isNotEmpty((CharSequence)config.getServerId()), (String)config.getRegistryUrl());
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                builder = new PublicDockerHubRuntimeHandlerImpl.Builder();
                break;
            }
            case PRIVATE_DOCKER_HUB: {
                builder = new PrivateDockerHubRuntimeHandlerImpl.Builder().dockerCredentialProvider((IDockerCredentialProvider)MavenDockerCredentialProvider.fromMavenSettings((Settings)config.getMavenSettings(), (String)config.getServerId()));
                break;
            }
            case PRIVATE_REGISTRY: {
                builder = new PrivateRegistryRuntimeHandlerImpl.Builder().dockerCredentialProvider((IDockerCredentialProvider)MavenDockerCredentialProvider.fromMavenSettings((Settings)config.getMavenSettings(), (String)config.getServerId()));
                break;
            }
            default: {
                throw new AzureExecutionException("Invalid docker runtime configured.");
            }
        }
        ((WebAppRuntimeHandler.Builder)builder.image(config.getImage())).registryUrl(config.getRegistryUrl());
        return builder;
    }

    @Override
    public SettingsHandler getSettingsHandler(AbstractWebAppMojo mojo) {
        return new SettingsHandlerImpl(mojo);
    }

    @Override
    public ArtifactHandler getArtifactHandler(AbstractWebAppMojo mojo) throws AzureExecutionException {
        switch (SchemaVersion.fromString(mojo.getSchemaVersion())) {
            case V1: {
                return this.getV1ArtifactHandler(mojo);
            }
            case V2: {
                return this.getV2ArtifactHandler(mojo);
            }
        }
        throw new AzureExecutionException("Unknown value of <schemaVersion> in pom.xml.");
    }

    protected ArtifactHandler getV1ArtifactHandler(AbstractWebAppMojo mojo) throws AzureExecutionException {
        Object builder;
        if (mojo.getContainerSettings() != null && StringUtils.isNotEmpty((CharSequence)mojo.getContainerSettings().getImageName())) {
            return new NONEArtifactHandlerImpl.Builder().build();
        }
        switch (mojo.getDeploymentType()) {
            case FTP: {
                builder = new FTPArtifactHandlerImpl.Builder();
                break;
            }
            case ZIP: {
                builder = new ZIPArtifactHandlerImpl.Builder();
                break;
            }
            case JAR: {
                builder = new JarArtifactHandlerImpl.Builder().jarFile(mojo.getJarFile());
                break;
            }
            case WAR: {
                builder = new WarArtifactHandlerImpl.Builder().warFile(mojo.getWarFile()).contextPath(mojo.getPath());
                break;
            }
            case NONE: {
                builder = new NONEArtifactHandlerImpl.Builder();
                break;
            }
            case EMPTY: 
            case AUTO: {
                builder = this.getArtifactHandlerBuilderFromPackaging(mojo);
                break;
            }
            default: {
                throw new AzureExecutionException("The value of <deploymentType> is unknown.");
            }
        }
        return builder.project(ProjectUtils.convertCommonProject((MavenProject)mojo.getProject())).stagingDirectoryPath(mojo.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(mojo.getBuildDirectoryAbsolutePath()).build();
    }

    protected ArtifactHandler getV2ArtifactHandler(AbstractWebAppMojo mojo) {
        if (StringUtils.isNotEmpty((CharSequence)mojo.getRuntime().getImage())) {
            return new NONEArtifactHandlerImpl.Builder().build();
        }
        return ((ArtifactHandlerImplV2.Builder)((ArtifactHandlerImplV2.Builder)new ArtifactHandlerImplV2.Builder().project(ProjectUtils.convertCommonProject((MavenProject)mojo.getProject()))).stagingDirectoryPath(mojo.getDeploymentStagingDirectoryPath())).runtime(mojo.getRuntime()).build();
    }

    protected ArtifactHandlerBase.Builder getArtifactHandlerBuilderFromPackaging(AbstractWebAppMojo mojo) throws AzureExecutionException {
        String packaging = mojo.getProject().getPackaging();
        if (StringUtils.isEmpty((CharSequence)packaging)) {
            throw new AzureExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
        }
        switch (packaging = packaging.toLowerCase(Locale.ENGLISH).trim()) {
            case "war": {
                return new WarArtifactHandlerImpl.Builder().warFile(mojo.getWarFile()).contextPath(mojo.getPath());
            }
            case "jar": {
                return new JarArtifactHandlerImpl.Builder().jarFile(mojo.getJarFile());
            }
        }
        throw new AzureExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
    }

    @Override
    public DeploymentSlotHandler getDeploymentSlotHandler(AbstractWebAppMojo mojo) {
        return new DeploymentSlotHandler(mojo);
    }
}

