/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.handlers.runtime.WebAppRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public class LinuxRuntimeHandlerImpl
extends WebAppRuntimeHandler {
    private LinuxRuntimeHandlerImpl(Builder builder) {
        super(builder);
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException {
        AppServicePlan plan = this.createOrGetAppServicePlan();
        return WebAppUtils.defineLinuxApp(this.resourceGroup, this.appName, this.azure, plan).withBuiltInImage(this.runtime);
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws AzureExecutionException {
        WebAppUtils.assureLinuxWebApp(app);
        WebAppUtils.clearTags(app);
        return ((WebApp.Update)app.update()).withBuiltInImage(this.runtime);
    }

    @Override
    protected OperatingSystem getAppServicePlatform() {
        return OperatingSystem.LINUX;
    }

    public static class Builder
    extends WebAppRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LinuxRuntimeHandlerImpl build() {
            return new LinuxRuntimeHandlerImpl(this);
        }
    }
}

