/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.validator;

import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotSetting;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConfigurationValidator {
    public static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    public static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9\\.\\_\\-\\(\\)]{1,90}";
    public static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    protected final AbstractWebAppMojo mojo;

    public AbstractConfigurationValidator(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    public String validateAppName() {
        String appName = this.mojo.getAppName();
        if (StringUtils.isEmpty((CharSequence)appName)) {
            return "Please config the <appName> in pom.xml.";
        }
        if (appName.startsWith("-") || !appName.matches(APP_NAME_PATTERN)) {
            return "The <appName> only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.";
        }
        return null;
    }

    public String validateResourceGroup() {
        String resourceGroupName = this.mojo.getResourceGroup();
        if (StringUtils.isEmpty((CharSequence)resourceGroupName)) {
            return "Please config the <resourceGroup> in pom.xml.";
        }
        if (resourceGroupName.endsWith(".") || !resourceGroupName.matches(RESOURCE_GROUP_PATTERN)) {
            return "The <resourceGroup> only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
        }
        return null;
    }

    public String validatePricingTier() {
        if (this.mojo.getPricingTier() != null && AppServiceUtils.getPricingTierFromString((String)this.mojo.getPricingTier()) == null) {
            return "Unknown value of the pricingTier.";
        }
        return null;
    }

    public String validateDeploymentSlot() {
        DeploymentSlotSetting deploymentSlotSetting = this.mojo.getDeploymentSlotSetting();
        if (deploymentSlotSetting == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)deploymentSlotSetting.getName())) {
            return "Please config the <name> of <deploymentSlot> in pom.xml";
        }
        if (!deploymentSlotSetting.getName().matches(SLOT_NAME_PATTERN)) {
            return String.format("Invalid value of <name> inside <deploymentSlot> in pom.xml, it needs to match the pattern '%s'", SLOT_NAME_PATTERN);
        }
        return null;
    }

    public abstract String validateRegion();

    public abstract String validateOs();

    public abstract String validateRuntimeStack();

    public abstract String validateImage();

    public abstract String validateJavaVersion();

    public abstract String validateWebContainer();
}

