/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfig;
import com.microsoft.azure.maven.webapp.utils.DeployUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    private static final String CREATE_WEBAPP = "Creating web app %s...";
    private static final String CREATE_WEB_APP_DONE = "Successfully created Web App %s.";
    private static final String UPDATE_WEBAPP = "Updating target Web App %s...";
    private static final String UPDATE_WEBAPP_DONE = "Successfully updated Web App %s.";
    private static final String CREATE_RESOURCE_GROUP = "Creating resource group %s in region %s...";
    private static final String CREATE_RESOURCE_GROUP_DONE = "Successfully created resource group %s.";
    private static final String CREATE_APP_SERVICE_PLAN = "Creating app service plan...";
    private static final String CREATE_APP_SERVICE_DONE = "Successfully created app service plan %s.";
    private static final String WEBAPP_NOT_EXIST_FOR_SLOT = "The Web App specified in pom.xml does not exist. Please make sure the Web App name is correct.";
    private static final String CREATE_DEPLOYMENT_SLOT = "Creating deployment slot %s in web app %s";
    private static final String CREATE_DEPLOYMENT_SLOT_DONE = "Successfully created the Deployment Slot.";
    private static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    private static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker app service";
    private static final String NO_RUNTIME_CONFIG = "You need to specified <runtime> in pom.xml for creating azure webapps.";
    private static final String CREATE_NEW_APP_SERVICE_PLAN = "createNewAppServicePlan";
    private static final String CREATE_NEW_RESOURCE_GROUP = "createNewResourceGroup";
    private static final String CREATE_NEW_WEB_APP = "createNewWebApp";
    private static final String CREATE_NEW_DEPLOYMENT_SLOT = "createNewDeploymentSlot";

    protected void doExecute() throws AzureExecutionException {
        this.validateConfiguration(message -> AzureMessager.getMessager().error(message.getMessage()), true);
        this.az = this.getOrCreateAzureAppServiceClient();
        WebAppConfig config = this.getWebAppConfig();
        IWebAppBase target = this.createOrUpdateResource(config);
        this.deploy(target, config);
    }

    private IWebAppBase createOrUpdateResource(WebAppConfig config) throws AzureExecutionException {
        if (StringUtils.isEmpty((CharSequence)config.getDeploymentSlotName())) {
            IWebApp webApp = this.getWebApp(config);
            return webApp.exists() ? this.updateWebApp(webApp, config) : this.createWebApp(webApp, config);
        }
        IWebAppDeploymentSlot slot = this.getDeploymentSlot(config);
        return slot.exists() ? this.updateDeploymentSlot(slot, config) : this.createDeploymentSlot(slot, config);
    }

    private IWebApp getWebApp(WebAppConfig config) {
        return this.az.webapp(config.getResourceGroup(), config.getAppName());
    }

    private IWebAppDeploymentSlot getDeploymentSlot(WebAppConfig config) throws AzureExecutionException {
        IWebApp webApp = this.getWebApp(config);
        if (!webApp.exists()) {
            throw new AzureExecutionException(WEBAPP_NOT_EXIST_FOR_SLOT);
        }
        return webApp.deploymentSlot(config.getDeploymentSlotName());
    }

    private IWebApp createWebApp(IWebApp webApp, WebAppConfig webAppConfig) throws AzureExecutionException {
        if (webAppConfig.getRuntime() == null) {
            throw new AzureExecutionException(NO_RUNTIME_CONFIG);
        }
        this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_WEB_APP, String.valueOf(true));
        ResourceGroup resourceGroup = this.getOrCreateResourceGroup(webAppConfig);
        IAppServicePlan appServicePlan = this.getOrCreateAppServicePlan(webAppConfig);
        AzureMessager.getMessager().info(String.format(CREATE_WEBAPP, webAppConfig.getAppName()));
        IWebApp result = (IWebApp)webApp.create().withName(webAppConfig.getAppName()).withResourceGroup(resourceGroup.name()).withPlan(appServicePlan.id()).withRuntime(webAppConfig.getRuntime()).withDockerConfiguration(webAppConfig.getDockerConfiguration()).withAppSettings(webAppConfig.getAppSettings()).commit();
        AzureMessager.getMessager().info(String.format(CREATE_WEB_APP_DONE, result.name()));
        return result;
    }

    private IWebApp updateWebApp(IWebApp webApp, WebAppConfig webAppConfig) {
        IAppServicePlan targetServicePlan;
        AzureMessager.getMessager().info(String.format(UPDATE_WEBAPP, webApp.name()));
        IAppServicePlan currentPlan = webApp.plan();
        IAppServicePlan iAppServicePlan = targetServicePlan = StringUtils.isEmpty((CharSequence)webAppConfig.getServicePlanName()) ? currentPlan : this.az.appServicePlan(this.getServicePlanResourceGroup(webAppConfig), webAppConfig.getServicePlanName());
        if (!targetServicePlan.exists()) {
            targetServicePlan = this.getOrCreateAppServicePlan(webAppConfig);
        } else if (webAppConfig.getPricingTier() != null) {
            targetServicePlan.update().withPricingTier(webAppConfig.getPricingTier()).commit();
        }
        IWebApp result = (IWebApp)webApp.update().withPlan(targetServicePlan.id()).withRuntime(webAppConfig.getRuntime()).withDockerConfiguration(webAppConfig.getDockerConfiguration()).withAppSettings(webAppConfig.getAppSettings()).commit();
        AzureMessager.getMessager().info(String.format(UPDATE_WEBAPP_DONE, webApp.name()));
        return result;
    }

    private ResourceGroup getOrCreateResourceGroup(WebAppConfig webAppConfig) {
        AzureResourceManager azureResourceManager = this.az.getAzureResourceManager(webAppConfig.getSubscriptionId());
        try {
            return (ResourceGroup)azureResourceManager.resourceGroups().getByName(webAppConfig.getResourceGroup());
        }
        catch (ManagementException e) {
            AzureMessager.getMessager().info(String.format(CREATE_RESOURCE_GROUP, webAppConfig.getResourceGroup(), webAppConfig.getRegion().getName()));
            this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_RESOURCE_GROUP, String.valueOf(true));
            ResourceGroup result = (ResourceGroup)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)azureResourceManager.resourceGroups().define(webAppConfig.getResourceGroup())).withRegion(webAppConfig.getRegion().getName())).create();
            AzureMessager.getMessager().info(String.format(CREATE_RESOURCE_GROUP_DONE, webAppConfig.getResourceGroup()));
            return result;
        }
    }

    private IAppServicePlan getOrCreateAppServicePlan(WebAppConfig webAppConfig) {
        String servicePlanName = StringUtils.isEmpty((CharSequence)webAppConfig.getServicePlanName()) ? this.getNewAppServicePlanName(webAppConfig) : webAppConfig.getServicePlanName();
        String servicePlanGroup = this.getServicePlanResourceGroup(webAppConfig);
        IAppServicePlan appServicePlan = this.az.appServicePlan(servicePlanGroup, servicePlanName);
        if (!appServicePlan.exists()) {
            AzureMessager.getMessager().info(CREATE_APP_SERVICE_PLAN);
            this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_APP_SERVICE_PLAN, String.valueOf(true));
            appServicePlan.create().withName(servicePlanName).withResourceGroup(servicePlanGroup).withRegion(webAppConfig.getRegion()).withPricingTier(webAppConfig.getPricingTier()).withOperatingSystem(webAppConfig.getRuntime().getOperatingSystem()).commit();
            AzureMessager.getMessager().info(String.format(CREATE_APP_SERVICE_DONE, appServicePlan.name()));
        }
        return appServicePlan;
    }

    private String getNewAppServicePlanName(WebAppConfig webAppConfig) {
        return StringUtils.isEmpty((CharSequence)webAppConfig.getServicePlanName()) ? String.format("asp-%s", webAppConfig.getAppName()) : webAppConfig.getServicePlanName();
    }

    private String getServicePlanResourceGroup(WebAppConfig webAppConfig) {
        return StringUtils.isEmpty((CharSequence)webAppConfig.getServicePlanResourceGroup()) ? webAppConfig.getResourceGroup() : webAppConfig.getServicePlanResourceGroup();
    }

    private IWebAppDeploymentSlot createDeploymentSlot(IWebAppDeploymentSlot slot, WebAppConfig webAppConfig) {
        AzureMessager.getMessager().info(String.format(CREATE_DEPLOYMENT_SLOT, webAppConfig.getDeploymentSlotName(), webAppConfig.getAppName()));
        this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_DEPLOYMENT_SLOT, String.valueOf(true));
        IWebAppDeploymentSlot result = slot.create().withName(webAppConfig.getDeploymentSlotName()).withConfigurationSource(webAppConfig.getDeploymentSlotConfigurationSource()).withAppSettings(webAppConfig.getAppSettings()).commit();
        AzureMessager.getMessager().info(CREATE_DEPLOYMENT_SLOT_DONE);
        return result;
    }

    private void deploy(IWebAppBase target, WebAppConfig config) throws AzureExecutionException {
        if (target.getRuntime().isDocker()) {
            AzureMessager.getMessager().info(SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE);
            return;
        }
        try {
            AzureMessager.getMessager().info(String.format(DEPLOY_START, config.getAppName()));
            if (this.isStopAppDuringDeployment()) {
                WebAppUtils.stopAppService((IAppService)target);
            }
            this.deployArtifacts(target, config);
            this.deployExternalResources((IAppService)target);
            AzureMessager.getMessager().info(String.format(DEPLOY_FINISH, target.hostName()));
        }
        finally {
            WebAppUtils.startAppService((IAppService)target);
        }
    }

    private IWebAppDeploymentSlot updateDeploymentSlot(IWebAppDeploymentSlot slot, WebAppConfig webAppConfig) {
        return slot;
    }

    private void deployArtifacts(IWebAppBase target, WebAppConfig config) throws AzureExecutionException {
        List<WebAppArtifact> artifactsOneDeploy = config.getWebAppArtifacts().stream().filter(artifact -> artifact.getDeployType() != null).collect(Collectors.toList());
        artifactsOneDeploy.forEach(resource -> target.deploy(resource.getDeployType(), resource.getFile(), resource.getPath()));
        List<WebAppArtifact> artifacts = config.getWebAppArtifacts().stream().filter(artifact -> artifact.getDeployType() == null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(artifacts)) {
            return;
        }
        if (artifacts.size() == 1) {
            WebAppArtifact artifact2 = artifacts.get(0);
            DeployType deployType = DeployType.getDeployTypeFromFile((File)artifact2.getFile());
            target.deploy(deployType, artifact2.getFile(), artifact2.getPath());
            return;
        }
        if (DeployUtils.isAllWarArtifacts(artifacts)) {
            artifacts.forEach(resource -> target.deploy(DeployType.getDeployTypeFromFile((File)resource.getFile()), resource.getFile(), resource.getPath()));
            return;
        }
        this.deployArtifactsWithZipDeploy(target, artifacts);
    }

    private void deployArtifactsWithZipDeploy(IWebAppBase target, List<WebAppArtifact> artifacts) throws AzureExecutionException {
        File stagingDirectory = DeployMojo.prepareStagingDirectory(artifacts);
        if (Objects.equals(target.getRuntime().getWebContainer(), WebContainer.JAVA_SE)) {
            ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles((File)stagingDirectory, null, (boolean)true));
            DeployUtils.prepareJavaSERuntimeJarArtifact(files, this.project.getBuild().getFinalName());
        }
        File zipFile = Utils.createTempFile(this.appName + UUID.randomUUID(), ".zip");
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        target.deploy(DeployType.ZIP, zipFile);
    }

    private static File prepareStagingDirectory(List<WebAppArtifact> webAppArtifacts) throws AzureExecutionException {
        try {
            File stagingDirectory = Files.createTempDirectory("azure-functions", new FileAttribute[0]).toFile();
            FileUtils.forceDeleteOnExit((File)stagingDirectory);
            for (WebAppArtifact webAppArtifact : webAppArtifacts) {
                File targetFolder = StringUtils.isEmpty((CharSequence)webAppArtifact.getPath()) ? stagingDirectory : new File(stagingDirectory, webAppArtifact.getPath());
                FileUtils.copyFileToDirectory((File)webAppArtifact.getFile(), (File)targetFolder);
            }
            return stagingDirectory;
        }
        catch (IOException e) {
            throw new AzureExecutionException("Failed to package resources", (Throwable)e);
        }
    }

    private void deployExternalResources(IAppService target) throws AzureExecutionException {
        DeployUtils.deployResourcesWithFtp(target, this.filterResources(DeploymentResource::isExternalResource));
    }

    private List<DeploymentResource> filterResources(Predicate<DeploymentResource> predicate) {
        List resources = this.deployment == null ? Collections.emptyList() : this.deployment.getResources();
        return resources.stream().filter(predicate).collect(Collectors.toList());
    }
}

