/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.maven.appservice.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.maven.utils.MavenArtifactUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotConfig;
import com.microsoft.azure.maven.webapp.configuration.MavenRuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.ExpandableParameter;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.settings.Settings;

public class ConfigParser {
    private static final String EXPANDABLE_PRICING_TIER_WARNING = "'%s' may not be a valid pricing tier, please refer to https://aka.ms/maven_webapp_runtime#pricingtier for valid values";
    private static final String EXPANDABLE_REGION_WARNING = "'%s' may not be a valid region, please refer to https://aka.ms/maven_webapp_runtime#region for valid values";
    private static final String EXPANDABLE_WEB_CONTAINER_WARNING = "'%s' may not be a valid web container, please refer to https://aka.ms/maven_webapp_runtime#webcontainer for valid values";
    private static final String EXPANDABLE_JAVA_VERSION_WARNING = "'%s' may not be a valid java version, recommended values are `Java 8`, `Java 11` and `Java 17`";
    protected AbstractWebAppMojo mojo;

    public ConfigParser(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    public AppServiceConfig getAppServiceConfig() throws AzureExecutionException {
        return new AppServiceConfig().subscriptionId(this.getSubscriptionId()).resourceGroup(this.getResourceGroup()).appName(this.getAppName()).servicePlanName(this.getAppServicePlanName()).servicePlanResourceGroup(this.getAppServicePlanResourceGroup()).deploymentSlotName(this.getDeploymentSlotName()).deploymentSlotConfigurationSource(this.getDeploymentSlotConfigurationSource()).pricingTier(this.getPricingTier()).region(this.getRegion()).runtime(this.getRuntimeConfig()).appSettings(this.mojo.getAppSettings());
    }

    public WebAppConfiguration getWebAppConfiguration() {
        WebAppConfiguration.WebAppConfigurationBuilder<Object, Object> builder = WebAppConfiguration.builder();
        Runtime runtime = this.getRuntime();
        OperatingSystem os = Optional.ofNullable(runtime).map(Runtime::getOperatingSystem).orElse(null);
        if (os == null) {
            Log.debug((String)"No runtime related config is specified. It will cause error if creating a new web app.");
        } else {
            switch (os) {
                case WINDOWS: 
                case LINUX: {
                    builder = ((WebAppConfiguration.WebAppConfigurationBuilder)builder.javaVersion(Objects.toString(runtime.getJavaVersion()))).webContainer(Objects.toString(runtime.getWebContainer()));
                    break;
                }
                case DOCKER: {
                    MavenRuntimeConfig runtimeConfig = this.mojo.getRuntime();
                    builder = ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.image(runtimeConfig.getImage())).serverId(runtimeConfig.getServerId())).registryUrl(runtimeConfig.getRegistryUrl());
                    break;
                }
                default: {
                    Log.debug((String)"Invalid operating system from the configuration.");
                }
            }
        }
        return ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.appName(this.getAppName())).resourceGroup(this.getResourceGroup())).region(this.getRegion())).pricingTier(Optional.ofNullable(this.getPricingTier()).map(PricingTier::getSize).orElse(null))).servicePlanName(this.mojo.getAppServicePlanName())).servicePlanResourceGroup(this.mojo.getAppServicePlanResourceGroup())).deploymentSlotSetting(this.mojo.getDeploymentSlotSetting())).os(os)).mavenSettings(this.mojo.getSettings())).resources(Optional.ofNullable(this.mojo.getDeployment()).map(Deployment::getResources).orElse(null))).stagingDirectoryPath(this.mojo.getDeploymentStagingDirectoryPath())).buildDirectoryAbsolutePath(this.mojo.getBuildDirectoryAbsolutePath())).project(this.mojo.getProject())).session(this.mojo.getSession())).filtering(this.mojo.getMavenResourcesFiltering())).schemaVersion("v2")).build();
    }

    public DeploymentSlotConfig getDeploymentSlotConfig() {
        return DeploymentSlotConfig.builder().subscriptionId(this.getSubscriptionId()).resourceGroup(this.getResourceGroup()).appName(this.getAppName()).name(this.getDeploymentSlotName()).configurationSource(this.getDeploymentSlotConfigurationSource()).appSettings(this.mojo.getAppSettings()).build();
    }

    public List<WebAppArtifact> getArtifacts() throws AzureExecutionException {
        if (this.mojo.getDeployment() == null || this.mojo.getDeployment().getResources() == null) {
            return Collections.emptyList();
        }
        return ConfigParser.convertResourceToArtifacts(this.mojo.getDeployment().getResources());
    }

    public List<DeploymentResource> getExternalArtifacts() {
        if (this.mojo.getDeployment() == null || this.mojo.getDeployment().getResources() == null) {
            return Collections.emptyList();
        }
        return this.mojo.getDeployment().getResources().stream().filter(DeploymentResource::isExternalResource).collect(Collectors.toList());
    }

    public String getAppName() {
        return this.mojo.getAppName();
    }

    public String getResourceGroup() {
        return this.mojo.getResourceGroup();
    }

    public String getDeploymentSlotName() {
        return this.mojo.getDeploymentSlotSetting() == null ? null : this.mojo.getDeploymentSlotSetting().getName();
    }

    public String getDeploymentSlotConfigurationSource() {
        return this.mojo.getDeploymentSlotSetting() == null ? null : this.mojo.getDeploymentSlotSetting().getConfigurationSource();
    }

    public PricingTier getPricingTier() {
        if (StringUtils.isEmpty((CharSequence)this.mojo.getPricingTier())) {
            return null;
        }
        return ConfigParser.parseExpandableParameter(input -> {
            if (StringUtils.contains((CharSequence)this.mojo.getPricingTier(), (CharSequence)"_")) {
                String[] pricingParams = this.mojo.getPricingTier().split("_");
                return PricingTier.fromString((String)pricingParams[0], (String)pricingParams[1]);
            }
            return PricingTier.fromString((String)this.mojo.getPricingTier());
        }, this.mojo.getPricingTier(), EXPANDABLE_PRICING_TIER_WARNING);
    }

    public String getAppServicePlanName() {
        return this.mojo.getAppServicePlanName();
    }

    public String getAppServicePlanResourceGroup() {
        return this.mojo.getAppServicePlanResourceGroup();
    }

    public String getSubscriptionId() {
        return this.mojo.getSubscriptionId();
    }

    public Region getRegion() {
        if (StringUtils.isEmpty((CharSequence)this.mojo.getRegion())) {
            return null;
        }
        return ConfigParser.parseExpandableParameter(Region::fromName, this.mojo.getRegion(), EXPANDABLE_REGION_WARNING);
    }

    public Runtime getRuntime() {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null || runtime.isEmpty()) {
            return null;
        }
        OperatingSystem os = this.getOs(runtime);
        if (os == OperatingSystem.DOCKER) {
            return Runtime.DOCKER;
        }
        JavaVersion javaVersion = StringUtils.isEmpty((CharSequence)runtime.getJavaVersion()) ? null : ConfigParser.parseExpandableParameter(JavaVersion::fromString, runtime.getJavaVersion(), EXPANDABLE_JAVA_VERSION_WARNING);
        WebContainer webContainer = StringUtils.isEmpty((CharSequence)runtime.getWebContainer()) ? null : ConfigParser.parseExpandableParameter(WebContainer::fromString, runtime.getWebContainer(), EXPANDABLE_WEB_CONTAINER_WARNING);
        return Runtime.getRuntime((OperatingSystem)os, (WebContainer)webContainer, (JavaVersion)javaVersion);
    }

    private OperatingSystem getOs(MavenRuntimeConfig runtime) {
        return OperatingSystem.fromString((String)runtime.getOs());
    }

    private RuntimeConfig getRuntimeConfig() throws AzureExecutionException {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null || runtime.isEmpty()) {
            return null;
        }
        OperatingSystem os = this.getOs(runtime);
        JavaVersion javaVersion = StringUtils.isEmpty((CharSequence)runtime.getJavaVersion()) ? null : ConfigParser.parseExpandableParameter(JavaVersion::fromString, runtime.getJavaVersion(), EXPANDABLE_JAVA_VERSION_WARNING);
        WebContainer webContainer = StringUtils.isEmpty((CharSequence)runtime.getWebContainer()) ? null : ConfigParser.parseExpandableParameter(WebContainer::fromString, runtime.getWebContainer(), EXPANDABLE_WEB_CONTAINER_WARNING);
        RuntimeConfig result = new RuntimeConfig().os(os).javaVersion(javaVersion).webContainer(webContainer).image(runtime.getImage()).registryUrl(runtime.getRegistryUrl());
        if (StringUtils.isNotEmpty((CharSequence)runtime.getServerId())) {
            MavenDockerCredentialProvider credentialProvider = this.getDockerCredential(runtime.getServerId());
            result.username(credentialProvider.getUsername()).password(credentialProvider.getPassword());
        }
        return result;
    }

    protected MavenDockerCredentialProvider getDockerCredential(String serverId) {
        return MavenDockerCredentialProvider.fromMavenSettings((Settings)this.mojo.getSettings(), (String)serverId);
    }

    protected static List<WebAppArtifact> convertResourceToArtifacts(List<DeploymentResource> resources) throws AzureExecutionException {
        try {
            return CollectionUtils.isEmpty(resources) ? Collections.emptyList() : resources.stream().filter(resource -> !resource.isExternalResource()).flatMap(resource -> ConfigParser.convertResourceToArtifacts(resource).stream()).collect(Collectors.toList());
        }
        catch (Throwable ex) {
            throw new AzureExecutionException(String.format("Cannot parse deployment resources due to error: %s.", ex.getMessage()), ex);
        }
    }

    private static <T extends ExpandableParameter> T parseExpandableParameter(Function<String, T> parser, String input, String prompt) {
        ExpandableParameter result = (ExpandableParameter)parser.apply(input);
        if (StringUtils.isNotEmpty((CharSequence)input) && result.isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(prompt, input));
        }
        return (T)result;
    }

    private static List<WebAppArtifact> convertResourceToArtifacts(DeploymentResource resource) throws AzureToolkitRuntimeException {
        boolean isOneDeploymentResource = resource.isOneDeployResource();
        if (isOneDeploymentResource) {
            return ConfigParser.convertOneDeployResourceToArtifacts((Resource)resource);
        }
        return ConfigParser.convertLegacyResourceToArtifacts(resource);
    }

    private static List<WebAppArtifact> convertLegacyResourceToArtifacts(DeploymentResource resource) {
        List artifacts = MavenArtifactUtils.getArtifacts((Resource)resource);
        return artifacts.stream().map(file -> WebAppArtifact.builder().file(file).deployType(DeployType.getDeployTypeFromFile((File)file)).path(resource.getTargetPath()).build()).collect(Collectors.toList());
    }

    private static List<WebAppArtifact> convertOneDeployResourceToArtifacts(Resource resource) {
        List artifacts = MavenArtifactUtils.getArtifacts((Resource)resource);
        String typeString = ((DeploymentResource)resource).getType();
        DeployType type = DeployType.fromString((String)typeString);
        Objects.requireNonNull(type, () -> String.format("Unsupported resource type '%s', please change to one from this list: %s", typeString, DeployType.values().stream().map(Object::toString).map(StringUtils::lowerCase).collect(Collectors.joining(", "))));
        if (type.requireSingleFile() && artifacts.size() > 1) {
            throw new AzureToolkitRuntimeException(String.format("Multiple files are found for resource type('%s'), only one file is allowed.", type));
        }
        if (artifacts.isEmpty()) {
            Log.warn((String)String.format("Cannot find any files defined by resource(%s)", StringUtils.firstNonBlank((CharSequence[])new String[]{resource.toString()})));
        }
        if (type.ignorePath() && StringUtils.isNotBlank((CharSequence)resource.getTargetPath())) {
            throw new AzureToolkitRuntimeException(String.format("'<targetPath>' is not allowed for deployable type('%s').", type));
        }
        if (StringUtils.isNotBlank((CharSequence)type.getFileExt())) {
            String expectFileExtension = type.getFileExt();
            for (File file2 : artifacts) {
                if (StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getExtension((String)file2.getName()), (CharSequence)expectFileExtension)) continue;
                throw new AzureToolkitRuntimeException(String.format("Wrong file '%s' Deployable type('%s'), expected file type '%s'", file2, type, expectFileExtension));
            }
        }
        return artifacts.stream().map(file -> WebAppArtifact.builder().file(file).deployType(type).path(ConfigParser.getRemotePath(type, resource, file)).build()).collect(Collectors.toList());
    }

    private static String getRemotePath(@Nonnull DeployType type, Resource resource, File file) {
        if (type.ignorePath()) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getTargetPath()) || type.requirePath()) {
            String toDir = ConfigParser.normalizePathString(StringUtils.defaultString((String)resource.getTargetPath()), type.getTargetPathPrefix(), "/");
            return ConfigParser.normalizePath(Paths.get(StringUtils.defaultString((String)toDir), file.getName()).toString());
        }
        return null;
    }

    private static String normalizePathString(String path, String ... prefixes) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String normalizedPath = StringUtils.trim((String)ConfigParser.normalizePath(path));
            for (String prefix : prefixes) {
                normalizedPath = StringUtils.removeStart((String)normalizedPath, (String)prefix);
            }
            return normalizedPath;
        }
        return "";
    }

    private static String normalizePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        return StringUtils.removeEnd((String)path.replaceAll("([\\\\/])+", Matcher.quoteReplacement("/")), (String)"/");
    }
}

