/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.task;

import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.maven.webapp.utils.FTPUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.maven.model.Resource;

@Deprecated
public class DeployExternalResourcesTask
extends AzureTask<WebAppBase<?, ?, ?>> {
    private static final String DEPLOY_START = "Trying to deploy external resources to %s...";
    private static final String DEPLOY_FINISH = "Successfully deployed the resources to %s";
    final WebAppBase<?, ?, ?> target;
    final List<DeploymentResource> resources;

    public DeployExternalResourcesTask(WebAppBase<?, ?, ?> target, List<DeploymentResource> resources) {
        this.target = target;
        this.resources = resources;
    }

    public WebAppBase<?, ?, ?> doExecute() {
        AzureMessager.getMessager().info(AzureString.format((String)DEPLOY_START, (Object[])new Object[]{this.target.name()}));
        this.deployExternalResources((AppServiceAppBase<?, ?, ?>)this.target, this.resources);
        AzureMessager.getMessager().info(AzureString.format((String)DEPLOY_FINISH, (Object[])new Object[]{this.target.name()}));
        return this.target;
    }

    private void deployExternalResources(AppServiceAppBase<?, ?, ?> target, List<DeploymentResource> resources) {
        if (resources.isEmpty()) {
            return;
        }
        AzureMessager.getMessager().info(AzureString.format((String)"Uploading resources to %s", (Object[])new Object[]{target.name()}));
        PublishingProfile publishingProfile = target.getPublishingProfile();
        String serverUrl = publishingProfile.getFtpUrl().split("/", 2)[0];
        try {
            FTPClient ftpClient = FTPUtils.getFTPClient(serverUrl, publishingProfile.getFtpUsername(), publishingProfile.getFtpPassword());
            for (DeploymentResource externalResource : resources) {
                DeployExternalResourcesTask.uploadResource(externalResource, ftpClient);
            }
        }
        catch (IOException e) {
            throw new AzureToolkitRuntimeException((Throwable)e);
        }
    }

    private static void uploadResource(DeploymentResource resource, FTPClient ftpClient) throws IOException {
        List<File> files = Utils.getArtifacts((Resource)resource);
        String target = resource.getAbsoluteTargetPath();
        for (File file : files) {
            FTPUtils.uploadFile(ftpClient, file.getPath(), target);
        }
    }
}

