/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.serializer;

import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.serializer.ConfigurationSerializer;
import com.microsoft.azure.maven.webapp.utils.XMLUtils;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

public class V2ConfigurationSerializer
extends ConfigurationSerializer {
    public V2ConfigurationSerializer(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs) {
        super(newConfigs, oldConfigs);
    }

    @Override
    public void saveToXML(Element configurationElement) throws MojoFailureException {
        this.createOrUpdateAttribute("schemaVersion", "v2", this.oldConfigs.getSchemaVersion(), configurationElement);
        this.createOrUpdateAttribute("subscriptionId", this.newConfigs.getSubscriptionId(), this.oldConfigs.getSubscriptionId(), configurationElement);
        this.createOrUpdateAttribute("resourceGroup", this.newConfigs.getResourceGroup(), this.oldConfigs.getResourceGroup(), configurationElement);
        this.createOrUpdateAttribute("appName", this.newConfigs.getAppName(), this.oldConfigs.getAppName(), configurationElement);
        this.createOrUpdateAttribute("pricingTier", this.newConfigs.getPricingTier(), this.oldConfigs.getPricingTier(), configurationElement);
        if (this.newConfigs.getRegion() != null) {
            String oldRegion = this.oldConfigs.getRegion() == null ? null : this.oldConfigs.getRegion().toString();
            this.createOrUpdateAttribute("region", this.newConfigs.getRegion().toString(), oldRegion, configurationElement);
        }
        this.createOrUpdateAttribute("appServicePlanName", this.newConfigs.getServicePlanName(), this.oldConfigs.getServicePlanName(), configurationElement);
        this.createOrUpdateAttribute("appServicePlanResourceGroup", this.newConfigs.getServicePlanResourceGroup(), this.oldConfigs.getServicePlanResourceGroup(), configurationElement);
        if (this.newConfigs.getOs() != null) {
            this.updateRunTimeNode(this.newConfigs, this.oldConfigs, configurationElement);
        }
        if (this.newConfigs.getDeploymentSlotSetting() == null) {
            XMLUtils.removeNode(configurationElement, "deploymentSlot");
        } else {
            Element deploymentSlot = XMLUtils.getOrCreateSubElement("deploymentSlot", configurationElement);
            DeploymentSlotSetting oldDeploymentSlotSetting = this.oldConfigs.getDeploymentSlotSetting() == null ? new DeploymentSlotSetting() : this.oldConfigs.getDeploymentSlotSetting();
            this.updateDeploymentSlotNode(this.newConfigs.getDeploymentSlotSetting(), oldDeploymentSlotSetting, deploymentSlot);
        }
        if (configurationElement.element("deployment") == null && this.newConfigs.getResources() != null) {
            configurationElement.add((Element)this.createDeploymentNode(this.newConfigs));
        }
    }

    private void updateRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) throws MojoFailureException {
        Element runtime = XMLUtils.getOrCreateSubElement("runtime", configurationElement);
        if (!newConfigs.getOs().equals((Object)oldConfigs.getOs()) && V2ConfigurationSerializer.isDockerOs(newConfigs.getOs()) != V2ConfigurationSerializer.isDockerOs(oldConfigs.getOs())) {
            if (V2ConfigurationSerializer.isDockerOs(newConfigs.getOs())) {
                XMLUtils.removeSubNode(runtime, "javaVersion");
                XMLUtils.removeSubNode(runtime, "webContainer");
            } else {
                XMLUtils.removeSubNode(runtime, "image");
                XMLUtils.removeSubNode(runtime, "serverId");
                XMLUtils.removeSubNode(runtime, "registryUrl");
            }
        }
        switch (newConfigs.getOs()) {
            case LINUX: 
            case WINDOWS: {
                this.updateNonDockerRunTimeNode(newConfigs, oldConfigs, runtime);
                break;
            }
            case DOCKER: {
                this.updateDockerRunTimeNode(newConfigs, oldConfigs, runtime);
                break;
            }
            default: {
                throw new MojoFailureException("The value of <os> is unknown.");
            }
        }
    }

    private void updateNonDockerRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) {
        String oldOS = V2ConfigurationSerializer.formatOperationSystem(oldConfigs.getOs());
        this.createOrUpdateAttribute("os", newConfigs.getOs().toString(), oldOS, configurationElement);
        if (StringUtils.isNotBlank((CharSequence)newConfigs.getJavaVersion())) {
            String oldJavaVersion = Objects.toString(oldConfigs.getJavaVersion(), null);
            this.createOrUpdateAttribute("javaVersion", Objects.toString(newConfigs.getJavaVersion(), null), oldJavaVersion, configurationElement);
        }
        if (StringUtils.isNotBlank((CharSequence)newConfigs.getWebContainer())) {
            String oldWebContainer = Objects.toString(oldConfigs.getWebContainer());
            this.createOrUpdateAttribute("webContainer", Objects.toString(newConfigs.getWebContainer()), oldWebContainer, configurationElement);
        }
    }

    private void updateDockerRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) {
        String oldOS = V2ConfigurationSerializer.formatOperationSystem(oldConfigs.getOs());
        this.createOrUpdateAttribute("os", "Docker", oldOS, configurationElement);
        this.createOrUpdateAttribute("image", newConfigs.getImage(), oldConfigs.getImage(), configurationElement);
        this.createOrUpdateAttribute("serverId", newConfigs.getServerId(), oldConfigs.getServerId(), configurationElement);
        this.createOrUpdateAttribute("registryUrl", newConfigs.getRegistryUrl(), oldConfigs.getRegistryUrl(), configurationElement);
    }

    protected void updateDeploymentSlotNode(DeploymentSlotSetting newConfigs, DeploymentSlotSetting oldConfigs, Element deploymentSlotRoot) {
        this.createOrUpdateAttribute("name", newConfigs.getName(), oldConfigs.getName(), deploymentSlotRoot);
        this.createOrUpdateAttribute("configurationSource", newConfigs.getConfigurationSource(), oldConfigs.getConfigurationSource(), deploymentSlotRoot);
    }

    private DOMElement createDeploymentNode(WebAppConfiguration webAppConfiguration) {
        DOMElement deploymentNode = new DOMElement("deployment");
        deploymentNode.add((Element)this.createResourcesNode(webAppConfiguration.getResources()));
        return deploymentNode;
    }

    private static boolean isDockerOs(OperatingSystem os) {
        return Objects.equals(os, OperatingSystem.DOCKER);
    }

    private static String formatOperationSystem(OperatingSystem osEnum) {
        return Objects.toString(osEnum, null);
    }
}

