/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotConfig;
import com.microsoft.azure.maven.webapp.task.DeployExternalResourcesTask;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    private static final String WEBAPP_NOT_EXIST_FOR_SLOT = "The Web App specified in pom.xml does not exist. Please make sure the Web App name is correct.";
    private static final String CREATE_DEPLOYMENT_SLOT = "Creating deployment slot %s in web app %s";
    private static final String CREATE_DEPLOYMENT_SLOT_DONE = "Successfully created the Deployment Slot.";
    private static final String CREATE_NEW_DEPLOYMENT_SLOT = "createNewDeploymentSlot";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="webapp.deploy_app", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.validateConfiguration(message -> AzureMessager.getMessager().error(message.getMessage()), true);
            this.az = this.getOrCreateAzureAppServiceClient();
            IWebAppBase<?> target = this.createOrUpdateResource();
            this.deployExternalResources(target, this.getConfigParser().getExternalArtifacts());
            this.deploy(target, this.getConfigParser().getArtifacts());
            this.updateTelemetryProperties();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private IWebAppBase<?> createOrUpdateResource() throws AzureExecutionException {
        boolean skipCreate;
        boolean bl = skipCreate = this.skipAzureResourceCreate || this.skipCreateAzureResource;
        if (!this.isDeployToDeploymentSlot()) {
            AppServiceConfig appServiceConfig = this.getConfigParser().getAppServiceConfig();
            WebApp app = ((AzureAppService)Azure.az(AzureAppService.class)).webapp(appServiceConfig.resourceGroup(), appServiceConfig.appName());
            boolean newWebApp = !app.exists();
            AppServiceConfig defaultConfig = !newWebApp ? AppServiceConfigUtils.fromAppService((IAppService)app, (AppServicePlan)app.plan()) : this.buildDefaultConfig(appServiceConfig.subscriptionId(), appServiceConfig.resourceGroup(), appServiceConfig.appName());
            AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)appServiceConfig, (AppServiceConfig)defaultConfig);
            if (appServiceConfig.pricingTier() == null) {
                appServiceConfig.pricingTier(appServiceConfig.runtime().webContainer() == WebContainer.JBOSS_7 ? PricingTier.PREMIUM_P1V3 : PricingTier.PREMIUM_P1V2);
            }
            CreateOrUpdateWebAppTask task = new CreateOrUpdateWebAppTask(appServiceConfig);
            task.setSkipCreateAzureResource(skipCreate);
            return task.execute();
        }
        DeploymentSlotConfig config = this.getConfigParser().getDeploymentSlotConfig();
        WebAppDeploymentSlot slot = this.getDeploymentSlot(config);
        boolean slotExists = slot.exists();
        if (!slotExists && skipCreate) {
            Utils.throwForbidCreateResourceWarning((String)"Deployment slot", (String)config.getName());
        }
        return slotExists ? this.updateDeploymentSlot(slot, config) : this.createDeploymentSlot(slot, config);
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        ComparableVersion javaVersionForProject = null;
        String outputFileName = this.project.getBuild().getFinalName() + "." + this.project.getPackaging();
        File outputFile = new File(this.project.getBuild().getDirectory(), outputFileName);
        if (outputFile.exists() && StringUtils.equalsIgnoreCase((CharSequence)"jar", (CharSequence)this.project.getPackaging())) {
            try {
                javaVersionForProject = new ComparableVersion(com.microsoft.azure.toolkit.lib.common.utils.Utils.getArtifactCompileVersion((File)outputFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JavaVersion javaVersion = (javaVersionForProject = (ComparableVersion)ObjectUtils.firstNonNull((Object[])new ComparableVersion[]{javaVersionForProject, new ComparableVersion(System.getProperty("java.version"))})).compareTo(new ComparableVersion("9")) < 0 ? JavaVersion.JAVA_8 : JavaVersion.JAVA_11;
        return AppServiceConfigUtils.buildDefaultWebAppConfig((String)subscriptionId, (String)resourceGroup, (String)appName, (String)this.project.getPackaging(), (JavaVersion)javaVersion);
    }

    private WebAppDeploymentSlot getDeploymentSlot(DeploymentSlotConfig config) throws AzureExecutionException {
        WebApp webApp = this.az.webapp(config.getResourceGroup(), config.getAppName());
        if (!webApp.exists()) {
            throw new AzureExecutionException(WEBAPP_NOT_EXIST_FOR_SLOT);
        }
        return webApp.deploymentSlot(config.getName());
    }

    private WebAppDeploymentSlot createDeploymentSlot(WebAppDeploymentSlot slot, DeploymentSlotConfig slotConfig) {
        AzureMessager.getMessager().info(AzureString.format((String)CREATE_DEPLOYMENT_SLOT, (Object[])new Object[]{slotConfig.getName(), slotConfig.getAppName()}));
        this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_DEPLOYMENT_SLOT, String.valueOf(true));
        WebAppDeploymentSlot result = slot.create().withName(slotConfig.getName()).withConfigurationSource(slotConfig.getConfigurationSource()).withAppSettings(slotConfig.getAppSettings()).commit();
        AzureMessager.getMessager().info(CREATE_DEPLOYMENT_SLOT_DONE);
        return result;
    }

    private WebAppDeploymentSlot updateDeploymentSlot(WebAppDeploymentSlot slot, DeploymentSlotConfig slotConfig) {
        AzureMessager.getMessager().warning("update existing slot is not supported in current version");
        return slot;
    }

    private void deploy(IWebAppBase<?> target, List<WebAppArtifact> artifacts) {
        new DeployWebAppTask(target, artifacts, this.isStopAppDuringDeployment()).execute();
    }

    private void deployExternalResources(IWebAppBase<?> target, List<DeploymentResource> resources) {
        new DeployExternalResourcesTask(target, resources).execute();
    }

    static {
        DeployMojo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.webapp.DeployMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 56);
    }
}

