/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class WebAppUtils {
    private static final String SERVICE_PLAN_NOT_APPLICABLE = "The App Service Plan '%s' is not a %s Plan";
    private static final String CONFIGURATION_NOT_APPLICABLE = "The configuration is not applicable for the target Web App (%s). Please correct it in pom.xml.";
    private static final String STOP_APP = "Stopping Web App before deploying artifacts...";
    private static final String START_APP = "Starting Web App after deploying artifacts...";
    private static final String STOP_APP_DONE = "Successfully stopped Web App.";
    private static final String START_APP_DONE = "Successfully started Web App.";
    private static final String RUNNING = "Running";

    public static void stopAppService(IAppService target) {
        Log.info((String)STOP_APP);
        target.stop();
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Log.info((String)STOP_APP_DONE);
    }

    public static void startAppService(IAppService target) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)target.state(), (CharSequence)RUNNING)) {
            Log.info((String)START_APP);
            target.start();
            Log.info((String)START_APP_DONE);
        }
    }
}

