/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.task.DeployExternalResourcesTask;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="webapp.deploy_app", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.validateConfiguration(message -> AzureMessager.getMessager().error(message.getMessage()), true);
            this.az = this.initAzureAppServiceClient();
            WebAppBase<?, ?, ?> target = this.createOrUpdateResource();
            this.deployExternalResources(target, this.getConfigParser().getExternalArtifacts());
            this.deploy(target, this.getConfigParser().getArtifacts());
            this.updateTelemetryProperties();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private WebAppBase<?, ?, ?> createOrUpdateResource() throws AzureExecutionException {
        boolean skipCreate = this.skipAzureResourceCreate || this.skipCreateAzureResource;
        AppServiceConfig appServiceConfig = this.getConfigParser().getAppServiceConfig();
        WebApp app = (WebApp)((AzureWebApp)Azure.az(AzureWebApp.class)).webApps(appServiceConfig.subscriptionId()).getOrDraft(appServiceConfig.appName(), appServiceConfig.resourceGroup());
        AppServiceConfig defaultConfig = app.exists() ? AppServiceConfigUtils.fromAppService((AppServiceAppBase)app, (AppServicePlan)Objects.requireNonNull(app.getAppServicePlan())) : this.buildDefaultConfig(appServiceConfig.subscriptionId(), appServiceConfig.resourceGroup(), appServiceConfig.appName());
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)appServiceConfig, (AppServiceConfig)defaultConfig);
        if (appServiceConfig.pricingTier() == null) {
            appServiceConfig.pricingTier(appServiceConfig.runtime().webContainer() == WebContainer.JBOSS_7 ? PricingTier.PREMIUM_P1V3 : PricingTier.PREMIUM_P1V2);
        }
        CreateOrUpdateWebAppTask task = new CreateOrUpdateWebAppTask(appServiceConfig);
        task.setSkipCreateAzureResource(skipCreate);
        return task.doExecute();
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        ComparableVersion javaVersionForProject = null;
        String outputFileName = this.project.getBuild().getFinalName() + "." + this.project.getPackaging();
        File outputFile = new File(this.project.getBuild().getDirectory(), outputFileName);
        if (outputFile.exists() && StringUtils.equalsIgnoreCase((CharSequence)"jar", (CharSequence)this.project.getPackaging())) {
            try {
                javaVersionForProject = new ComparableVersion(Utils.getArtifactCompileVersion((File)outputFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JavaVersion javaVersion = (javaVersionForProject = (ComparableVersion)ObjectUtils.firstNonNull((Object[])new ComparableVersion[]{javaVersionForProject, new ComparableVersion(System.getProperty("java.version"))})).compareTo(new ComparableVersion("9")) < 0 ? JavaVersion.JAVA_8 : JavaVersion.JAVA_11;
        return AppServiceConfigUtils.buildDefaultWebAppConfig((String)subscriptionId, (String)resourceGroup, (String)appName, (String)this.project.getPackaging(), (JavaVersion)javaVersion);
    }

    private void deploy(WebAppBase<?, ?, ?> target, List<WebAppArtifact> artifacts) {
        new DeployWebAppTask(target, artifacts, this.isStopAppDuringDeployment()).doExecute();
    }

    private void deployExternalResources(WebAppBase<?, ?, ?> target, List<DeploymentResource> resources) {
        new DeployExternalResourcesTask(target, resources).doExecute();
    }

    static {
        DeployMojo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.webapp.DeployMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 48);
    }
}

