/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cognitiveservices.vision.customvision.training.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.CustomVisionTrainingClient;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.implementation.TrainingsImpl;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class CustomVisionTrainingClientImpl
extends AzureServiceClient
implements CustomVisionTrainingClient {
    private AzureClient azureClient;
    private String apiKey;
    private String endpoint;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private Trainings trainings;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String apiKey() {
        return this.apiKey;
    }

    @Override
    public CustomVisionTrainingClientImpl withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public String endpoint() {
        return this.endpoint;
    }

    @Override
    public CustomVisionTrainingClientImpl withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public CustomVisionTrainingClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public CustomVisionTrainingClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public CustomVisionTrainingClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    @Override
    public Trainings trainings() {
        return this.trainings;
    }

    public CustomVisionTrainingClientImpl(ServiceClientCredentials credentials) {
        this("https://{Endpoint}/customvision/v3.0/training", credentials);
    }

    public CustomVisionTrainingClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public CustomVisionTrainingClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.trainings = new TrainingsImpl(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "CustomVisionTrainingClient", "3.0");
    }
}

