/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.StoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkReadStoredProcedureResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

class BulkReadStoredProcedureExecutor {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private DocumentClient client;
    private String bulkReadSprocLink;
    private RequestOptions requestOptions;

    public BulkReadStoredProcedureExecutor(DocumentClient client, String bulkReadSprocLink, String partitionKeyRangeId) {
        this.client = client;
        this.bulkReadSprocLink = bulkReadSprocLink;
        class RequestOptionsInternal
        extends RequestOptions {
            RequestOptionsInternal(String partitionKeyRangeId) {
                this.setPartitionKeyRengeId(partitionKeyRangeId);
            }
        }
        this.requestOptions = new RequestOptionsInternal(partitionKeyRangeId);
        this.requestOptions.setScriptLoggingEnabled(true);
    }

    public BulkReadStoredProcedureResponse execute(String pkDefintition, String continuationPk, String continuationToken, int maxBatchCount) throws DocumentClientException, JsonParseException, JsonMappingException, IOException {
        StoredProcedureResponse response = this.client.executeStoredProcedure(this.bulkReadSprocLink, this.requestOptions, new Object[]{pkDefintition, continuationPk, continuationToken, maxBatchCount, null});
        BulkReadStoredProcedureResponse bulkReadResponse = this.parseFrom(response);
        bulkReadResponse.requestUnitsConsumed = response.getRequestCharge();
        return bulkReadResponse;
    }

    private BulkReadStoredProcedureResponse parseFrom(StoredProcedureResponse storedProcResponse) throws JsonParseException, JsonMappingException, IOException {
        String res = storedProcResponse.getResponseAsString();
        if (StringUtils.isEmpty((CharSequence)res)) {
            return null;
        }
        return (BulkReadStoredProcedureResponse)objectMapper.readValue(res, BulkReadStoredProcedureResponse.class);
    }
}

