/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class PathParser {
    private static final char SEGMENT_SEPARATOR = '/';
    private static final String ERROR_MESSAGE_FORMAT = "Invalid path \"%s\", failed at %d";

    PathParser() {
    }

    public static List<String> getPathParts(String path) {
        ArrayList<String> tokens = new ArrayList<String>();
        AtomicInteger currentIndex = new AtomicInteger();
        while (currentIndex.get() < path.length()) {
            char currentChar = path.charAt(currentIndex.get());
            if (currentChar != '/') {
                throw new IllegalArgumentException(String.format(ERROR_MESSAGE_FORMAT, path, currentIndex.get()));
            }
            if (currentIndex.incrementAndGet() == path.length()) break;
            currentChar = path.charAt(currentIndex.get());
            if (currentChar == '\"' || currentChar == '\'') {
                tokens.add(PathParser.getEscapedToken(path, currentIndex));
                continue;
            }
            tokens.add(PathParser.getToken(path, currentIndex));
        }
        return tokens;
    }

    private static String getEscapedToken(String path, AtomicInteger currentIndex) {
        char quote = path.charAt(currentIndex.get());
        int newIndex = currentIndex.incrementAndGet();
        while (true) {
            if ((newIndex = path.indexOf(quote, newIndex)) == -1) {
                throw new IllegalArgumentException(String.format(ERROR_MESSAGE_FORMAT, path, currentIndex.get()));
            }
            if (path.charAt(newIndex - 1) != '\\') break;
            ++newIndex;
        }
        String token = path.substring(currentIndex.get(), newIndex);
        currentIndex.set(newIndex + 1);
        return token;
    }

    private static String getToken(String path, AtomicInteger currentIndex) {
        int newIndex = path.indexOf(47, currentIndex.get());
        String token = null;
        if (newIndex == -1) {
            token = path.substring(currentIndex.get());
            currentIndex.set(path.length());
        } else {
            token = path.substring(currentIndex.get(), newIndex);
            currentIndex.set(newIndex);
        }
        token = token.trim();
        return token;
    }
}

