package com.microsoft.azure.documentdb.bulkexecutor;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

public class BulkDeleteFailure {

	/**
     * Exception causing the batch of deletes to fail
     */
	private Exception bulkDeleteFailureException;
	
	/**
     * List of <PartitionKey, DocumentId> tuples which could not be deleted successfully
     */
    private List<Pair<String, String>> pkIdTuplesFailedToDelete;
    
    public BulkDeleteFailure() {
    	this.pkIdTuplesFailedToDelete = new ArrayList<>();
    }
    
    /**
     * Gets the exception which led to the bulk delete failure
     * @return Exception which led to the bulk delete failure
     */
    public Exception getBulkDeleteFailureException() {
    	return this.bulkDeleteFailureException;
    }
    
    /**
     * Sets the exception which led to the bulk delete failure
     * @param bulkDeleteFailureException Exception which led to the bulk delete failure
     */
    public void setBulkDeleteFailureException(Exception bulkDeleteFailureException) {
    	this.bulkDeleteFailureException = bulkDeleteFailureException;
    }
    
    /**
     * Gets the list of PartitionKey and DocumentId tuples which could not be deleted in bulk
     * @return List of PartitionKey and DocumentId tuples which could not be deleted in bulk
     */
    public List<Pair<String, String>> getPkIdTuplesFailedToDelete() {
    	return this.pkIdTuplesFailedToDelete;
    }
    
    /**
     * Sets the list of PartitionKey and DocumentId tuples which could not be deleted in bulk
     * @param pkIdTuplesFailedToDelete List of PartitionKey and DocumentId tuples which could not be deleted in bulk
     */
    public void setPkIdTuplesFailedToDelete(List<Pair<String, String>> pkIdTuplesFailedToDelete) {
    	this.pkIdTuplesFailedToDelete = pkIdTuplesFailedToDelete;
    }
}
