package com.microsoft.azure.documentdb.bulkexecutor;

import java.util.ArrayList;
import java.util.List;

public class BulkImportFailure {
    
    /**
     * Exception causing the batch of documents to not be inserted
     */
    private Exception bulkImportFailureException;
    
    /**
     * List of documents which could not be imported successfully
     */
    private List<String> documentsFailedToImport;

    public BulkImportFailure() {
        this.documentsFailedToImport = new ArrayList<>();
    }
    
    /**
     * Gets the exception which led to the bulk import failure
     * @return Exception that led to bulk import failure
     */
    public Exception getBulkImportFailureException() {
        return bulkImportFailureException;
    }

    /**
     * Sets the exception which caused the bulk import failure
     * @param bulkImportFailureException Exception that led to bulk import failure
     */
    public void setBulkImportFailureException(Exception bulkImportFailureException) {
        this.bulkImportFailureException = bulkImportFailureException;
    }

    /**
     * Gets the list of documents which were not successfully imported
     * @return List of documents which could not be imported
     */
    public List<String> getDocumentsFailedToImport() {
        return documentsFailedToImport;
    }

    /**
     * Sets the list of documents which were not successfully imported
     * @param documentsFailedToImport List of documents which could not be imported
     */
    public void setDocumentsFailedToImport(List<String> documentsFailedToImport) {
        this.documentsFailedToImport = documentsFailedToImport;
    }

}
