package com.microsoft.azure.documentdb.bulkexecutor;

import java.util.ArrayList;
import java.util.List;

public class BulkUpdateFailure {
    
    /**
     * Exception causing the batch of {@link UpdateItem.class} to not be updated
     */
    private Exception bulkUpdateFailureException;
    
    /**
     * List of UpdateItem which could not be updated successfully
     */
    private List<UpdateItem> failedUpdateItems;

    public BulkUpdateFailure() {
        this.failedUpdateItems = new ArrayList<>();
    }
    
    /**
     * Gets the exception which led to the bulk update failure
     * @return Exception that led to bulk update failure
     */
    public Exception getBulkUpdateFailureException() {
        return bulkUpdateFailureException;
    }

    /**
     * Sets the exception which caused the bulk update failure
     * @param bulkUpdateFailureException Exception that led to bulk update failure
     */
    public void setBulkUpdateFailureException(Exception bulkUpdateFailureException) {
        this.bulkUpdateFailureException = bulkUpdateFailureException;
    }

    /**
     * Gets the list of UpdateItems which were not successfully updated
     * @return failedUpdateItems List UpdateItems which could not be updated in bulk
     */
    public List<UpdateItem> getFailedUpdateItems() {
        return failedUpdateItems;
    }

    /**
     * Sets the list of UpdateItems which were not successfully updated
     * @param failedUpdateItems List UpdateItems which could not be updated in bulk
     */
    public void setFailedUpdates(List<UpdateItem> failedUpdateItems) {
        this.failedUpdateItems = failedUpdateItems;
    }

}
