/*
 * The MIT License (MIT)
 * Copyright (c) 2018 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.documentdb.SqlParameterCollection;

public class BulkDeleteQuerySpec {
    /**
     * Represents the bulk import progress index
     */
    @JsonProperty("rootSymbol")
    public final String rootSymbol;

    /**
     * Represents the query filter expression for the BulkDeleteQuerySpec
     */
    @JsonProperty("filterExpr")
    public final String filterExpression;

    /**
     * Represents the order by expression for the BulkDeleteQuerySpec
     */
    @JsonProperty("orderByExpr")
    public final String orderByExpression;

    /**
     * Represents the the list of parameters for the SqlQuerySpec to be executed server side
     */
    @JsonProperty("sqlParameterCollection")
    public final SqlParameterCollection sqlParameterCollection;
    
    /**
     * Represents the bulk import progress index
     */
    @JsonProperty("limit")
    public final int limit;

    public BulkDeleteQuerySpec(
            String rootSymbol,
            String filterExpression,
            String orderByExpression,
            SqlParameterCollection sqlParameterCollection,
            int limit){
        this.rootSymbol = rootSymbol;
        this.filterExpression = filterExpression;
        this.orderByExpression = orderByExpression;
        this.sqlParameterCollection = sqlParameterCollection;
        this.limit = limit;
    }

}
