/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor;

import com.microsoft.azure.documentdb.bulkexecutor.BulkDeleteFailure;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class BulkDeleteResponse {
    private final int numberOfDocumentsDeleted;
    private final double totalRequestUnitsConsumed;
    private final Duration totalTimeTaken;
    private final List<Exception> failures;
    private final List<BulkDeleteFailure> failedDeletes;

    public BulkDeleteResponse(int numberOfDocumentsDeleted, double totalRequestUnitsConsumed, Duration totalTimeTaken, List<Exception> failures, List<BulkDeleteFailure> failedDeletes) {
        this.numberOfDocumentsDeleted = numberOfDocumentsDeleted;
        this.totalRequestUnitsConsumed = totalRequestUnitsConsumed;
        this.totalTimeTaken = totalTimeTaken;
        this.failures = failures;
        this.failedDeletes = failedDeletes;
    }

    public int getNumberOfDocumentsDeleted() {
        return this.numberOfDocumentsDeleted;
    }

    public double getTotalRequestUnitsConsumed() {
        return this.totalRequestUnitsConsumed;
    }

    public Duration getTotalTimeTaken() {
        return this.totalTimeTaken;
    }

    public List<Exception> getErrors() {
        return Collections.unmodifiableList(this.failures);
    }

    public List<BulkDeleteFailure> getFailedDeletes() {
        return Collections.unmodifiableList(this.failedDeletes);
    }
}

