/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor;

import com.microsoft.azure.documentdb.bulkexecutor.BulkUpdateFailure;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class BulkUpdateResponse {
    private final int numberOfDocumentsUpdated;
    private final double totalRequestUnitsConsumed;
    private final Duration totalTimeTaken;
    private final List<BulkUpdateFailure> failedUpdates;
    private final List<Exception> failures;

    BulkUpdateResponse(int numberOfDocumentsUpdated, double totalRequestUnitsConsumed, Duration totalTimeTaken, List<Exception> failures, List<BulkUpdateFailure> failedUpdates) {
        this.numberOfDocumentsUpdated = numberOfDocumentsUpdated;
        this.totalRequestUnitsConsumed = totalRequestUnitsConsumed;
        this.totalTimeTaken = totalTimeTaken;
        this.failures = failures;
        this.failedUpdates = failedUpdates;
    }

    public List<Exception> getErrors() {
        return Collections.unmodifiableList(this.failures);
    }

    public int getNumberOfDocumentsUpdated() {
        return this.numberOfDocumentsUpdated;
    }

    public double getTotalRequestUnitsConsumed() {
        return this.totalRequestUnitsConsumed;
    }

    public Duration getTotalTimeTaken() {
        return this.totalTimeTaken;
    }

    public List<BulkUpdateFailure> getFailedUpdates() {
        return this.failedUpdates;
    }
}

