/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.SqlParameter;
import com.microsoft.azure.documentdb.SqlParameterCollection;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.StoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.BulkDeleteFailure;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkDeleteQuerySpec;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkDeleteStoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.internal.ExceptionUtils;
import com.microsoft.azure.documentdb.bulkexecutor.internal.RequestOptionsInternal;
import com.microsoft.azure.documentdb.repackaged.com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDeleter {
    private final String partitionKeyRangeId;
    private final DocumentClient client;
    public AtomicInteger numberOfDocumentsDeleted;
    public AtomicDouble totalRequestUnitsConsumed;
    private final String bulkDeleteSprocLink;
    private final BulkDeleteQuerySpec querySpec;
    private RequestOptions requestOptions;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(BatchDeleter.class);
    private final int maxRetryCountOnTimeouts = 5;
    private static final int DEFAULT_BULK_DELETE_BATCH_SIZE = 1000;
    private List<Pair<String, String>> pkIdTuplesToDelete;
    private List<BulkDeleteFailure> failedDeletes;

    public BatchDeleter(String partitionKeyRangeId, DocumentClient client, String bulkDeleteSprocLink, BulkDeleteQuerySpec querySpec) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.client = client;
        this.bulkDeleteSprocLink = bulkDeleteSprocLink;
        this.querySpec = querySpec;
        this.numberOfDocumentsDeleted = new AtomicInteger();
        this.totalRequestUnitsConsumed = new AtomicDouble();
        this.requestOptions = new RequestOptions();
        this.failedDeletes = new ArrayList<BulkDeleteFailure>();
        this.requestOptions = new RequestOptionsInternal(partitionKeyRangeId);
    }

    public BatchDeleter(String partitionKeyRangeId, DocumentClient client, String bulkDeleteSprocLink, PartitionKeyDefinition partitionKeyDefinition, List<Pair<String, String>> pkIdTuplesToDelete) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.client = client;
        this.bulkDeleteSprocLink = bulkDeleteSprocLink;
        this.numberOfDocumentsDeleted = new AtomicInteger();
        this.totalRequestUnitsConsumed = new AtomicDouble();
        this.pkIdTuplesToDelete = pkIdTuplesToDelete;
        this.querySpec = this.getBulkDeleteQuerySpecForMiniBatch(pkIdTuplesToDelete, partitionKeyDefinition);
        this.failedDeletes = new ArrayList<BulkDeleteFailure>();
        this.requestOptions = new RequestOptionsInternal(partitionKeyRangeId);
    }

    public int getNumberOfDocumentsDeleted() {
        return this.numberOfDocumentsDeleted.get();
    }

    public double getTotalRequestUnitsConsumed() {
        return this.totalRequestUnitsConsumed.get();
    }

    public List<BulkDeleteFailure> getBulkDeleteFailures() {
        return this.failedDeletes;
    }

    public Callable<Void> executeDelete() {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean isDeleteCompleted = false;
                int numberOfTimeouts = 0;
                while (!isDeleteCompleted) {
                    BulkDeleteFailure bulkDeleteFailure;
                    String errorMessage;
                    BulkDeleteFailure bulkDeleteFailure2;
                    boolean isThrottled = false;
                    Duration retryAfter = Duration.ZERO;
                    StoredProcedureResponse storedProcedureResponse = null;
                    try {
                        storedProcedureResponse = BatchDeleter.this.client.executeStoredProcedure(BatchDeleter.this.bulkDeleteSprocLink, BatchDeleter.this.requestOptions, new Object[]{BatchDeleter.this.querySpec, null});
                        BulkDeleteStoredProcedureResponse bulkDeleteResponse = BatchDeleter.this.parseFrom(storedProcedureResponse);
                        if (bulkDeleteResponse != null) {
                            if (!bulkDeleteResponse.done) {
                                logger.warn("pki {} | Delete execution did not complete, retrying..", (Object)BatchDeleter.this.partitionKeyRangeId);
                            }
                            isDeleteCompleted = bulkDeleteResponse.done;
                            BatchDeleter.this.numberOfDocumentsDeleted.addAndGet(bulkDeleteResponse.count);
                            BatchDeleter.this.totalRequestUnitsConsumed.addAndGet(storedProcedureResponse.getRequestCharge());
                        } else {
                            logger.warn("pki {} Failed to receive response", (Object)BatchDeleter.this.partitionKeyRangeId);
                        }
                    }
                    catch (DocumentClientException e) {
                        if (ExceptionUtils.isThrottled(e)) {
                            logger.debug("pki {} Throttled on partition range id", (Object)BatchDeleter.this.partitionKeyRangeId);
                            isThrottled = true;
                            retryAfter = Duration.ofMillis(e.getRetryAfterInMilliseconds());
                        } else if (ExceptionUtils.isTimedOut(e)) {
                            logger.debug("pki {} Request timed out", (Object)BatchDeleter.this.partitionKeyRangeId);
                            if (numberOfTimeouts < 5) {
                                ++numberOfTimeouts;
                            } else {
                                bulkDeleteFailure2 = new BulkDeleteFailure();
                                bulkDeleteFailure2.getPkIdTuplesFailedToDelete().addAll(BatchDeleter.this.pkIdTuplesToDelete);
                                bulkDeleteFailure2.setBulkDeleteFailureException((Exception)((Object)e));
                                BatchDeleter.this.failedDeletes.add(bulkDeleteFailure2);
                                isDeleteCompleted = true;
                            }
                        } else if (ExceptionUtils.isUnavailable(e)) {
                            logger.debug("pki {} Service unavailable", (Object)BatchDeleter.this.partitionKeyRangeId);
                        } else if (ExceptionUtils.isGone(e)) {
                            if (ExceptionUtils.isSplit(e)) {
                                errorMessage = String.format("pki %s is undergoing split, please retry shortly after re-initializing BulkExecutor", BatchDeleter.this.partitionKeyRangeId);
                                logger.error(errorMessage);
                                bulkDeleteFailure = new BulkDeleteFailure();
                                bulkDeleteFailure.getPkIdTuplesFailedToDelete().addAll(BatchDeleter.this.pkIdTuplesToDelete);
                                bulkDeleteFailure.setBulkDeleteFailureException((Exception)((Object)e));
                                BatchDeleter.this.failedDeletes.add(bulkDeleteFailure);
                                isDeleteCompleted = true;
                            } else {
                                errorMessage = String.format("pki %s is gone, please retry shortly after re-initializing BulkExecutor", BatchDeleter.this.partitionKeyRangeId);
                                logger.error(errorMessage);
                                bulkDeleteFailure = new BulkDeleteFailure();
                                bulkDeleteFailure.getPkIdTuplesFailedToDelete().addAll(BatchDeleter.this.pkIdTuplesToDelete);
                                bulkDeleteFailure.setBulkDeleteFailureException((Exception)((Object)e));
                                BatchDeleter.this.failedDeletes.add(bulkDeleteFailure);
                                isDeleteCompleted = true;
                            }
                        } else {
                            errorMessage = String.format("pki %s failed to delete. Exception was %s. Status code was %s", BatchDeleter.this.partitionKeyRangeId, e.getMessage(), e.getStatusCode());
                            logger.error(errorMessage, (Throwable)e);
                            bulkDeleteFailure = new BulkDeleteFailure();
                            bulkDeleteFailure.getPkIdTuplesFailedToDelete().addAll(BatchDeleter.this.pkIdTuplesToDelete);
                            bulkDeleteFailure.setBulkDeleteFailureException((Exception)((Object)e));
                            BatchDeleter.this.failedDeletes.add(bulkDeleteFailure);
                            isDeleteCompleted = true;
                        }
                    }
                    catch (Exception e) {
                        errorMessage = String.format("pki %s Failed to delete. Exception was %s", BatchDeleter.this.partitionKeyRangeId, e.getMessage());
                        logger.error(errorMessage, (Throwable)e);
                        bulkDeleteFailure = new BulkDeleteFailure();
                        bulkDeleteFailure.getPkIdTuplesFailedToDelete().addAll(BatchDeleter.this.pkIdTuplesToDelete);
                        bulkDeleteFailure.setBulkDeleteFailureException(e);
                        BatchDeleter.this.failedDeletes.add(bulkDeleteFailure);
                        isDeleteCompleted = true;
                    }
                    if (!isThrottled) continue;
                    try {
                        logger.debug("pki {} throttled going to sleep for {} millis ", (Object)BatchDeleter.this.partitionKeyRangeId, (Object)retryAfter.toMillis());
                        Thread.sleep(retryAfter.toMillis());
                    }
                    catch (InterruptedException e) {
                        bulkDeleteFailure2 = new BulkDeleteFailure();
                        bulkDeleteFailure2.getPkIdTuplesFailedToDelete().addAll(BatchDeleter.this.pkIdTuplesToDelete);
                        bulkDeleteFailure2.setBulkDeleteFailureException(e);
                        BatchDeleter.this.failedDeletes.add(bulkDeleteFailure2);
                        isDeleteCompleted = true;
                    }
                }
                return null;
            }
        };
    }

    private BulkDeleteStoredProcedureResponse parseFrom(StoredProcedureResponse storedProcResponse) throws JsonParseException, JsonMappingException, IOException {
        String res = storedProcResponse.getResponseAsString();
        logger.debug("Bulk Delete for Partition Key Range Id {}: Stored Proc Response as String {}", (Object)this.partitionKeyRangeId, (Object)res);
        if (StringUtils.isEmpty((CharSequence)res)) {
            return null;
        }
        return (BulkDeleteStoredProcedureResponse)objectMapper.readValue(res, BulkDeleteStoredProcedureResponse.class);
    }

    private BulkDeleteQuerySpec getBulkDeleteQuerySpecForMiniBatch(List<Pair<String, String>> pkIdPairsToDelete, PartitionKeyDefinition partitionKeyDefinition) {
        String partitionKeyField = ((String)partitionKeyDefinition.getPaths().iterator().next()).replaceFirst("/", "").replace('/', '.');
        StringBuilder bulkDeleteQuerySpecBuilder = new StringBuilder();
        bulkDeleteQuerySpecBuilder.append("(c.");
        bulkDeleteQuerySpecBuilder.append(partitionKeyField).append(" = \"").append((String)pkIdPairsToDelete.get(0).getKey()).append("\"");
        bulkDeleteQuerySpecBuilder.append(" and c.id = \"").append((String)pkIdPairsToDelete.get(0).getValue()).append("\")");
        for (int eachPkIdPairToDeleteIndex = 1; eachPkIdPairToDeleteIndex < pkIdPairsToDelete.size(); ++eachPkIdPairToDeleteIndex) {
            Pair<String, String> eachPkIdPairToDelete = pkIdPairsToDelete.get(eachPkIdPairToDeleteIndex);
            String partitionKey = (String)eachPkIdPairToDelete.getKey();
            String id = (String)eachPkIdPairToDelete.getValue();
            bulkDeleteQuerySpecBuilder.append("or (c.");
            bulkDeleteQuerySpecBuilder.append(partitionKeyField).append(" = \"").append(partitionKey).append("\"");
            bulkDeleteQuerySpecBuilder.append(" and c.id = \"").append(id).append("\")");
        }
        String root = "c";
        String filterExpression = bulkDeleteQuerySpecBuilder.toString();
        SqlParameterCollection sqlParameterCollection = null;
        BulkDeleteQuerySpec bulkDeleteQuerySpec = new BulkDeleteQuerySpec(root, filterExpression, null, sqlParameterCollection, 1000);
        return bulkDeleteQuerySpec;
    }

    private SqlQuerySpec createPKIdTupleQuerySpec(List<Pair<String, String>> pkIdPairsToDelete, String partitionKeyField) {
        StringBuilder queryStringBuilder = new StringBuilder();
        SqlParameterCollection parameters = new SqlParameterCollection();
        queryStringBuilder.append("( ");
        for (int i = 0; i < pkIdPairsToDelete.size(); ++i) {
            Pair<String, String> pair = pkIdPairsToDelete.get(i);
            String pkValue = (String)pair.getLeft();
            String pkParamName = "@param" + 2 * i;
            parameters.add(new SqlParameter(pkParamName, (Object)pkValue));
            String idValue = (String)pair.getRight();
            String idParamName = "@param" + (2 * i + 1);
            parameters.add(new SqlParameter(idParamName, (Object)idValue));
            queryStringBuilder.append("(");
            queryStringBuilder.append(" c.");
            queryStringBuilder.append(partitionKeyField);
            queryStringBuilder.append(" = ");
            queryStringBuilder.append(pkParamName);
            queryStringBuilder.append(" AND ");
            queryStringBuilder.append("c.id = ");
            queryStringBuilder.append(idParamName);
            queryStringBuilder.append(" )");
            if (i >= pkIdPairsToDelete.size() - 1) continue;
            queryStringBuilder.append(" OR ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }
}

