/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.Undefined;
import com.microsoft.azure.documentdb.bulkexecutor.internal.ExceptionUtils;
import com.microsoft.azure.documentdb.bulkexecutor.internal.PathParser;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAnalyzer {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentAnalyzer.class);

    public static PartitionKeyInternal extractPartitionKeyValue(String documentAsString, PartitionKeyDefinition partitionKeyDefinition) {
        if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            return PartitionKeyInternal.getEmpty();
        }
        return DocumentAnalyzer.extractPartitionKeyValueInternal(documentAsString, partitionKeyDefinition);
    }

    private static PartitionKeyInternal extractPartitionKeyValueInternal(String documentAsString, PartitionKeyDefinition partitionKeyDefinition) {
        try {
            Collection paths = partitionKeyDefinition.getPaths();
            JsonNode root = objectMapper.readTree(documentAsString);
            ArrayList<Undefined> partitionKeyValues = new ArrayList<Undefined>();
            for (String path : paths) {
                Object partitionKeyValue;
                block12: {
                    block11: {
                        JsonNode node;
                        Iterator<String> parts = PathParser.getPathParts(path).iterator();
                        for (node = root; parts.hasNext() && node != null; node = node.path(parts.next())) {
                        }
                        partitionKeyValue = null;
                        if (node == null) break block11;
                        switch (node.getNodeType()) {
                            case BOOLEAN: {
                                partitionKeyValue = node.booleanValue();
                                break block12;
                            }
                            case MISSING: {
                                partitionKeyValue = Undefined.Value();
                                break block12;
                            }
                            case NULL: {
                                partitionKeyValue = JSONObject.NULL;
                                break block12;
                            }
                            case NUMBER: {
                                partitionKeyValue = node.numberValue();
                                break block12;
                            }
                            case STRING: {
                                partitionKeyValue = node.textValue();
                                break block12;
                            }
                            default: {
                                throw new RuntimeException(String.format("undefined json type %s", node.getNodeType()));
                            }
                        }
                    }
                    partitionKeyValue = Undefined.Value();
                }
                partitionKeyValues.add((Undefined)partitionKeyValue);
            }
            return PartitionKeyInternal.fromObjectArray(partitionKeyValues, (boolean)false);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract partition key value from document {}", (Object)documentAsString, (Object)e);
            throw ExceptionUtils.toRuntimeException(e);
        }
    }

    public static PartitionKeyInternal fromPartitionKeyvalue(Object partitionKeyValue) {
        try {
            return PartitionKeyInternal.fromObjectArray(Collections.singletonList(partitionKeyValue), (boolean)true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate ParitionKeyInternal from {}", partitionKeyValue, (Object)e);
            throw ExceptionUtils.toRuntimeException(e);
        }
    }
}

