/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.microsoft.azure.documentdb.DocumentClientException;

public class ExceptionUtils {
    public static boolean isThrottled(DocumentClientException e) {
        return e.getStatusCode() == 429;
    }

    public static boolean isTimedOut(DocumentClientException e) {
        return e.getStatusCode() == 408;
    }

    public static boolean isUnavailable(DocumentClientException e) {
        return e.getStatusCode() == 503;
    }

    public static boolean isGone(DocumentClientException e) {
        return e.getStatusCode() == 410;
    }

    public static boolean isSplit(DocumentClientException e) {
        return e.getStatusCode() == 410 && 1007 == e.getSubStatusCode();
    }

    public static DocumentClientException getThrottelingException(Exception e) {
        DocumentClientException dce = null;
        while (e != null) {
            if (e instanceof DocumentClientException && ExceptionUtils.isThrottled(dce = (DocumentClientException)e)) {
                return dce;
            }
            if (!(e.getCause() instanceof Exception)) break;
            e = (Exception)e.getCause();
        }
        return null;
    }

    public static RuntimeException toRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static Exception toException(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new RuntimeException(t);
    }
}

