/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.microsoft.azure.documentdb.repackaged.com.google.common.base.Preconditions;
import java.time.Duration;

class OperationMetrics {
    final long numberOfDocumentsInserted;
    final Duration timeTaken;
    final double requestUnitsConsumed;
    final long numberOfThrottles;

    public OperationMetrics() {
        this(0L, Duration.ZERO, 0.0, 0L);
    }

    public OperationMetrics(long numberOfDocumentsInserted, Duration timeTaken, double requestUnitsConsumed, long numberOfThrottles) {
        Preconditions.checkArgument(numberOfDocumentsInserted >= 0L, "numberOfDocumentsInserted must be non negative");
        Preconditions.checkArgument(requestUnitsConsumed >= 0.0, "requestUnitsConsumed must be non negative");
        Preconditions.checkArgument(numberOfThrottles >= 0L, "numberOfThrottles must be non negative");
        this.numberOfDocumentsInserted = numberOfDocumentsInserted;
        this.timeTaken = timeTaken;
        this.requestUnitsConsumed = requestUnitsConsumed;
        this.numberOfThrottles = numberOfThrottles;
    }

    public static OperationMetrics sum(OperationMetrics m1, OperationMetrics m2) {
        long totalDocsInserted = m1.numberOfDocumentsInserted + m2.numberOfDocumentsInserted;
        Duration totalTimeTaken = m1.timeTaken.plus(m2.timeTaken);
        double totalRequestUnitsConsumed = m1.requestUnitsConsumed + m2.requestUnitsConsumed;
        long totalNumberOfThrottles = m1.numberOfThrottles + m2.numberOfThrottles;
        return new OperationMetrics(totalDocsInserted, totalTimeTaken, totalRequestUnitsConsumed, totalNumberOfThrottles);
    }
}

